/**
 * $Id: DefaultsPropertyNameURIHandlerTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.Defaults;
import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.ValueURIHandler;
import  com.idaremedia.antx.helpers.SIDs;
import  com.idaremedia.antx.valueuri.info.DefaultsPropertyNameURIHandler;

/**
 * Testsuite for {@linkplain XDefCheckValueURIHandler}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class DefaultsPropertyNameURIHandlerTest extends ValueURIHandlerTestSkeleton
{
    /**
     * Initializes a new test case for named method.
     * @param methodname test case method's name (non-null)
     **/
    public DefaultsPropertyNameURIHandlerTest(String methodname)
    {
        super("DefaultsPropertyNameURIHandler::",methodname);
    }


    /**
     * Returns full test suite for DefaultsPropertyNameURIHandler.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(DefaultsPropertyNameURIHandlerTest.class);
    }

//  ---------------------------------------------------------------------------------------------------------
//  --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    protected ValueURIHandler newOUT()
    {
        return new DefaultsPropertyNameURIHandler();
    }

//  ---------------------------------------------------------------------------------------------------------
//  ------------------------------------------- [ The Test Cases ] ------------------------------------------
//  ---------------------------------------------------------------------------------------------------------


    /**
     * Verify a blank uri fragment evaluates <i>null</i>.
     * @since JWare/AntX 0.5
     **/
    public void testBaseline_AntX05()
    {
        checkBaseline();
        
        ValueURIHandler out = newOUT();
        String result = out.valueFrom("","$defaultsproperty:",m_rqlink);
        assertNil(result,"$defaultsproperty:");
    }



    /**
     * Verify an unrecognized defaults attribute evaluates <i>null</i>.
     * @since JWare/AntX 0.5
     **/
    public void testUnknownDefaultsAttributeIsNull_AntX05()
    {
        ValueURIHandler out = newOUT();
        String propertyname = SIDs.next("defaults.");
        String result = out.valueFrom(propertyname,"$defaultsproperty:"+propertyname,m_rqlink);
        assertNil(result,"$defaultsproperty:[no-such-default]");
    }



    /**
     * Verify handler returns correct results for some known 
     * default property names.
     * @since JWare/AntX 0.5
     **/
    public void testFixedDefaultPropertyNames_AntX05()
    {
        ValueURIHandler out = newOUT();
        String result = out.valueFrom("noiselevel","$defaultsproperty:noiselevel",m_rqlink);
        assertEqual(result,AntX.DEFAULT_NOISELEVEL_PROP,"$defaultproperty:noiselevel");
    }



    /**
     * Verifies that the handler can deal with non-standard Iteration
     * subclasses and returns iteration-specific property names when
     * should.
     * @since JWare/AntX 0.5
     **/
    public void testConfigIdDependentPropertyNames_AntX05()
    {
        Defaults defaults = Iteration.defaultdefaults();
        ValueURIHandler out = newOUT();
        String result = out.valueFrom("assertions","$defaultsproperty:assertions",m_rqlink);
        assertEqual(result,defaults.isAssertionsDisabledName(),"$defaultsproperty:assertions");
        result = out.valueFrom("haltiferror.myzone","$defaultsproperty:haltiferror.myzone",m_rqlink);
        assertEqual(result,defaults.isHaltIfErrorName("myzone"),
                    "$defaultsproperty:haltiferror.myzone");

        assertNotEqual(Iteration.configId(),"throadwobblermangrove","Real Iteration ConfigId");
        Iteration.set(new MyIteration());
        try {
            assertEqual(Iteration.configId(),"throatwobblermangrove","Test Iteration ConfigId");
            Defaults mydefaults = Iteration.defaultdefaults();
            assertNotIdent(mydefaults,defaults,"Iteration.Defaults");
            result = out.valueFrom("passwordfile","$defaultsproperty:passwordfile",m_rqlink);
            assertEqual(result,mydefaults.passwordFileLocationName(),"$defaultsproperty:passwordfile");
            assertTrue(result.startsWith("throatwobblermangrove"));
        } finally {
            Iteration.reset();
        }
    }


    private static class MyIteration extends Iteration
    {
        private MyIteration() {
        }
        protected String getConfigId() {
            return "throatwobblermangrove";
        }
    }
}

/* end-of-DefaultsPropertyNameURIHandlerTest.java */