/**
 * $Id: PreferRuleTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.condition.PreferTask PreferTask}.
 * <em>Warning:These tests require a live internet connection to verify certain
 * HTTP-based assertions.</em>
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class PreferRuleTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new PreferRuleTest testcase.
     **/
    public PreferRuleTest(String methodName)
    {
        super("PreferTask::",methodName);
    }


    /**
     * Create full test suite for PreferTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(PreferRuleTest.class);
    }


    /**
     * Create baseline test suite for PreferTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("prefer.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testFailEmptyElement()
    {
        expectBuildExceptionContaining("undefined","Empty Assertion","At least one condition");
    }

    public void testUsingMsgId()
    {
        expectLogContaining("uses.msgid","Teensy Weensy Spider");
        assertPropertyEquals("truth.not","huh?");
    }

    public void testHttpAlive()
    {
        runTargetNoOutput("testHttpAlive");
        println("########",getFullLog());
        assertPropertyEquals("www.disable",null);
    }

    public void testSimpleTruths()
    {
        runTargetNoOutput("simple.truths");

        assertPropertyEquals("truth.istrue",null);
        assertPropertyEquals("truth.isfalse",null);
        assertPropertyEquals("truth.isset",null);
        assertPropertyEquals("truth.welcome",null);
        assertPropertyEquals("truth.isnotset",null);
        assertPropertyEquals("truth.varset",null);
        assertPropertyEquals("broken.varnotset",null);

        assertPropertyEquals("truth.notwhitespace",null);
        assertPropertyEquals("truth.antfile",null);
        assertPropertyEquals("truth.isnumeric",null);
        assertPropertyEquals("truth.isbool",null);
        assertPropertyEquals("truth.ishexnumeric",null);
        assertPropertyEquals("truth.varisbool",null);

        assertPropertyEquals("truth.file",null);
        assertPropertyEquals("truth.dir",null);
        assertPropertyEquals("truth.resource",null);
        assertPropertyEquals("truth.isclass",null);

        assertPropertyEquals("broken.allset",null);
        assertPropertyEquals("broken.noneset",null);
        assertPropertyEquals("broken.anyset",null);
    }

    public void testPropertyOverwriteImmediate()
    {
        runTarget("testPropertyOverwriteImmediate");
        assertPropertyEquals("my.required.property","default-value");
    }

    public void testPropertyOverwriteLikeVelcro()
    {
        runTarget("testPropertyOverwriteLikeVelcro");
    }

    public void testVariableUpdates()
    {
        runTarget("testVariableUpdates");
    }

    /** @since JWare/AntX 0.3 **/
    public void testRulesRunAllPreferences_AntX03()
    {
        runTargetDumpFullLog("testPreferRulesTallyAll");
    }

    public void testGoodReferrals_AntX02()
    {
        runTargetNoOutput("testReferrals");
        assertPropertyEquals("broken.referral0",null);
    }

    public void testCircularReferrals_AntX02()
    {
        String log= runExpecting("testCircularReferrals","CircularReferral");
        assertTrue(log.indexOf("rule chain contains a circular dependency")>-1,"Circular problem found");
    }

    public void testIncompatibleReferrals_AntX02()
    {
        String log= runExpecting("testIncompatibleReferrals","IncompatibleReferral");
        assertTrue(log.indexOf("must be compatible with effect")>-1,"Incompatibility found");
    }

    public void testMatches_AntX02()
    {
        runTarget("testMatches");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalsePrefers_AntX03()
    {
        runTarget("testFalsePrefers_AntX03");
        assertPropertyEquals("neg.istrue","huh?");
        assertPropertyEquals("neg.isfalse","huh?");
        assertPropertyEquals("neg.isset","huh?");
        assertPropertyEquals("neg.isnotset","huh?");
        assertPropertyEquals("neg.varset","huh?");
        assertPropertyEquals("neg.varnotset","huh?");
        assertPropertyEquals("neg.allset","huh?");
        assertPropertyEquals("neg.noneset","huh?");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseMessageNoiseLevels_AntX03()
    {
        runTarget("testFalseMessageNoiseLevels_AntX03");
    }

    /** @since JWare/AntX 0.3 **/
    public void testRulesAndCallerUpdateProperties_AntX03()
    {
        runTarget("testRulesAndCallerUpdateProperties_AntX03");
    }
}


/* end-of-PreferRuleTest.java */
