/**
 * $Id: ValueURIManagerTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.solo.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Unit test for {@linkplain com.idaremedia.antx.solo.ValueURIManagerTask}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class ValueURIManagerTaskTest extends HTC 
{

    /**
     * Initialize new test case for ValueURIManagerTask.
     * @param methodName test case (non-null)
     **/
    public ValueURIManagerTaskTest(String methodName) 
    {
        super("ValueURIManagerTask::",methodName);
    }


    /**
     * Create full test suite for ValueURIManagerTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ValueURIManagerTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }

// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("valueuris.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }
    
    
    public void testStandardURIs_AntX05()
    {
        runTarget("testStandardURIs_AntX05");
    }
    
    
    public void testSpacersRemoved_AntX05()
    {
        runTarget("testSpacersRemoved_AntX05");
    }


    public void testEmbeddedProperties_AntX05()
    {
        runTarget("testEmbeddedProperties_AntX05");
    }


    public void testCanCheckWhatsInstalled_AntX05()
    {
        runTarget("testCanCheckWhatsInstalled_AntX05");
    }
    
    
    public void testOverlayCoExistence_AntX05()
    {
        runTarget("testOverlayCoExistence_AntX05");
    }


    public void testInstallMessagesHandler_AntX05()
    {
        runTarget("testInstallMessagesHandler_AntX05");
    }


    public void testInstallShortHandConditionsHandler_AntX05()
    {
        runTarget("testInstallShortHandConditionsHandler_AntX05");
    }


    public void testInstallConditionHandler_AntX05()
    {
        runTarget("testInstallConditionHandler_AntX05");
    }
        
    public void testSimplePipeline_AntX05()
    {
        runTarget("testSimplePipeline_AntX05");
    }
    
    public void testEmptyFragmentsAllowed_AntX05()
    {
        runTarget("testEmptyFragmentsAllowed_AntX05");
    }
    
    public void testCallHandlersFromMacrosInDiffNamespace_AntX05()
    {
        runTarget("testCallHandlersFromMacrosInDiffNamespace_AntX05");
    }
}


/* end-of-ValueURIManagerTaskTest.java */