/**
 * $Id: LocalFixtureTaskSetTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.solo.tests;

import  java.util.Map;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.solo.LocalFixtureTaskSet;
import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;


/**
 * Unit test for {@linkplain com.idaremedia.antx.solo.LocalFixtureTaskSet
 * LocalFixtureTaskSet}.
 *
 * @since     JWare/AntX 0.4
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 * @see       com.idaremedia.antx.ownhelpers.ScopedProperties ScopedProperties
 * @see       com.idaremedia.antx.solo.LocalFixtureTaskSet LocalFixtureTaskSet
 **/

public final class LocalFixtureTaskSetTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new LocalFixtureTaskSetTest testcase.
     **/
    public LocalFixtureTaskSetTest(String methodName)
    {
        super("LocalFixtureTaskSet::",methodName);
    }


    /**
     * Create full test suite for LocalFixtureTaskSetTest.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(LocalFixtureTaskSetTest.class);
    }


    /**
     * Create baseline test suite for LocalFixtureTaskSetTest (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }

// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("localfix.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    /**
     * Verifies that meta attribute interpreted as expected.
     */
    public void testMetaOption_AntX04()
    {
        LocalFixtureTaskSet out = new LocalFixtureTaskSet();
        out.setProject(getProject());
        out.setMeta("name=ralph,phoneno=123456,marker,height=65ins");
        assertNotWhitespace(out.getMeta());
        Map map = out.getMetaMap();
        assertNotNil(map);
        assertEqual(map.size(),4,"ItemCount of Map");
        assertEqual(map.get("name"),"ralph");
        assertEqual(map.get("height"),"65ins");
        assertEqual(map.get("phoneno"),"123456");
        assertEqual(map.get("marker"),"");
    }

    public void testNestedRunAsExpected_AntX04()
    {
        runTarget("testNestedRunAsExpected_AntX04");
    }

    public void testMetaNotInstalled_AntX04()
    {
        runTarget("testMetaNotInstalled_AntX04");
    }

    public void testUnderscoreReplacement_AntX04()
    {
        runTarget("testUnderscoreReplacement_AntX04");
    }

    public void testOverrideExistingGlobal_AntX04()
    {
        runTarget("testOverrideExistingGlobal_AntX04");
    }

    public void testDefineGlobalFromLocal_AntX04()
    {
        runTarget("testDefineGlobalFromLocal_AntX04");
    }

    public void testDefineLocalOnly_AntX04()
    {
        runTarget("testDefineLocalOnly_AntX04");
    }

    public void testNestedLinkedScoped_AntX04()
    {
        runTarget("testNestedLinkedScoped_AntX04");
    }

    public void testEncodedValues_AntX04()
    {
        runTarget("testEncodedValues_AntX04");
    }

    public void testLoadFromExternal_AntX04()
    {
        runTarget("testLoadFromExternal_AntX04");
    }
    
    public void testHandleNamespacedItems_AntX05()
    {
        runTarget("testHandleNamespacedItems_AntX05");
    }
}

/* end-of-LocalFixtureTaskSetTest.java */
