/**
 * $Id: AutoRunLibraryTaskSet.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.solo;

import  org.apache.tools.ant.Task;
import  org.apache.tools.ant.TaskContainer;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AssertableLibDefinition;
import  com.idaremedia.antx.ownhelpers.TaskExaminer;
import  com.idaremedia.antx.starters.TaskSet;

/**
 * A taskset that is defined as part of a standard Ant library. The taskset's nested
 * elements are <em>automatically executed</em> when the library is installed which can
 * be immediate or delayed if the library is installed using the special "antlib:" XML
 * namespace construct (typical).
 * <p>
 * Do not use a autorun taskset to replace the standard 
 * <span class="src">&lt;import&gt;</span> task. Auto run scriptlets are most useful for
 * adhoc decoration of existing build or test scripts where the tasks run a simple fixture
 * configuration instructions (particularly if the setup spans projects).
 * <p>
 * You should pay careful attention to the tasks you include for autorun. Generally,
 * data object declarations, iteraton initializers, and other simple configuration tasks
 * are the best components to include in an antlib (aside from the other Ant definition
 * tasks like presetdefs and macrodefs).
 * <p>
 * Refer to the AntXtras/SAM project for a more elegant solution than autorun;
 * specifically &lt;run-configuration&gt;.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,infra
 * @.pattern  GoF.Adapter
 **/

public class AutoRunLibraryTaskSet extends AssertableLibDefinition
    implements TaskContainer
{
    /**
     * Initializes a new autorun taskset instance.
     **/
    public AutoRunLibraryTaskSet()
    {
        super(AntX.fixture+"AutoRun:");
    }



    /**
     * Initializes a new autorun taskset instance from subclass.
     * @param iam CV-label (non-null)
     **/
    public AutoRunLibraryTaskSet(String iam)
    {
        super(iam);
    }



    /**
     * Initializes this autorun taskset's internal helper. All add
     * requests are delegated to this helper.
     */
    public void init()
    {
        super.init();
        if (m_impl==null) {
            m_impl = new TaskSet();
            TaskExaminer.initTaskFrom(m_impl,this);
         }
    }



    /**
     * Adds a new task to this library task set. The new task is
     * actually added to the underlying taskset for later execution.
     */
    public void addTask(Task task)
    {
        m_impl.addTask(task);
    }



    /**
     * Performs all of this task's nested elements.
     * @throws org.apache.tools.ant.BuildException if any nested task does
     */
    public void execute()
    {
        verifyCanExecute_("exec");
        m_impl.perform();
    }



    private TaskSet m_impl;
}

/* end-of-AutoRunLibraryTaskSet.java */