/**
 * $Id: EnumSkeleton.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.parameters;

import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.types.EnumeratedAttribute;

import  com.idaremedia.antx.apis.FlexStringFriendly;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Enumeration attribute helper that implements the standard
 * <span class="src">equals()</span> and <span class="src">hashCode()</span>
 * methods to support proper comparison.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   impl,helper
 **/

public abstract class EnumSkeleton extends EnumeratedAttribute
    implements FlexStringFriendly
{
    /**
     * Initializes an undefined Enum instance.
     **/
    protected EnumSkeleton()
    {
        super();
    }


    /**
     * Use to create public singletons. Ensures the enum
     * instance is initialized as with default Ant
     * Introspector helper thingy.
     **/
    protected EnumSkeleton(String v)
    {
        super();
        Tk.initEnum(this,v);
        this.index = getIndex();
    }


    /**
     * Returns <i>true</i> if this enumerated attribute
     * equals incoming object (also an enumerated attribute).
     **/
    public boolean equals(Object o)
    {
        if (o==this) { return true;  }
        if (o==null) { return false; }
        if (o.getClass()==getClass()) {
            return ((EnumSkeleton)o).getIndex()==this.getIndex();
        }
        return false;
    }


    /**
     * Returns this modification's hash value; fixed when
     * constructed.
     **/
    public int hashCode()
    {
        return this.value.hashCode();
    }


    /**
     * Returns this enum's string value as the flex value.
     * @since JWare/AntX 0.3
     **/
    public String stringFrom(Project p)
    {
        return getValue();
    }


    /**
     * For VM singletons, initialized to this enum's index
     * in values array. Is "-1" if undefined (as with default
     * Ant Introspector helper thingy).
     **/
    protected int index= -1;
}

/* end-of-Enum.java */
