/**
 * $Id: DefinitionLoader.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ownhelpers;

import  org.apache.tools.ant.taskdefs.AntlibDefinition;
import  com.idaremedia.antx.AntX;

/**
 * Default implementation of a ClassLoader factory method for AntX Antlib definitions.
 * We assume that AntX definitions do not load tasks or types directly (only resources).
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 **/

public final class DefinitionLoader implements CustomLoaderFactoryMethod
{
    private static final String IAM_= "DefnLoader:";


    /**
     * Initializes this adapter for an existing definition.
     * @param defn existing Antlib definition (non-null)
     **/
    public DefinitionLoader(AntlibDefinition defn)
    {
        AntX.require_(defn!=null,IAM_,"ctor- nonzro definition");
        m_def= defn;
        m_spi= null;
    }



    /**
     * Initializes this adapter for an existing definition that also
     * supports instance-level customization.
     * @param defn existing Antlib definition (non-null)
     * @param next next loader after definitions (non-null)
     **/
    public DefinitionLoader(AntlibDefinition defn, CustomLoaderFactoryMethod next)
    {
        AntX.require_(defn!=null,IAM_,"ctor- nonzro definition");
        AntX.require_(next!=null,IAM_,"ctor- nonzro delegate");
        m_def= defn;
        m_spi= next;
    }



    /**
     * Returns the underlying definitions class loader. Can return
     * <i>null</i>.
     * @.safety single
     **/
    public ClassLoader getClassLoader()
    {
        if (m_cL==null) {
            ClassLoader cL= m_def.getAntlibClassLoader();
            if (cL==null && m_spi!=null) {
                cL = m_spi.getClassLoader();
            }
            m_cL = cL;
        }
        return m_cL;
    }


    private ClassLoader m_cL;//cached
    private final AntlibDefinition m_def;//NB:required
    private final CustomLoaderFactoryMethod m_spi;//NB:optional
}

/* end-of-DefinitionLoader.java */
