/**
 * $Id: Mkdirs.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.mktemp;

import  java.io.File;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.parameters.FeedbackLevel;

/**
 * Wrapper utility to create a collection of directories using the Java mkdirs API.
 * Copied from JWare/SAMS (BaseUrlsTools).
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    impl,helper
 **/

final class Mkdirs 
{
    /**
     * Ensures the named path refers to a readable directory. Will create directory
     * (including all parent directories) if necessary.
     * @param dir directory to be created (or checked) (non-null)
     * @param haltiferror set true if this method should signal error when cannot
     *             complete request.
     * @param fb problem reporting level (non-null)
     * @param clnt problem reporting conduit (non-null)
     * @throws BuildException if unable to create directories or non-directory 
     *             already exists.
     **/
    static boolean run(File dir, boolean haltiferror, FeedbackLevel fb, Requester clnt)
        throws BuildException
    {
        boolean okidoki=true;
        if (!dir.exists()) {
            try {
                dir.mkdirs();
                if (fb.getIndex()<FeedbackLevel.QUIET_INDEX) {
                    clnt.log("Directory created: "+dir.getPath(),
                              Project.MSG_INFO);
                }
            }
            catch (SecurityException secX) {
                String message = Iteration.uistrs().get("task.cant.access.dir",
                                                        dir.getPath());
                if (haltiferror) {
                    clnt.problem(message, Project.MSG_ERR);
                    throw new BuildException(message, secX, clnt.getLocation());
                }
                if (fb.getIndex()<FeedbackLevel.QUIET_INDEX) {//not-none|*quiet
                    clnt.problem(message, Project.MSG_WARN);
                }
                okidoki=false;
            }
        }
        else if (!dir.isDirectory() || !dir.canWrite() || !dir.canRead()) {
            String message;
            if (!dir.isDirectory()) {
                message = "mktemp.mkdirs.file.exists";
            } else {
                message = "task.cant.access.dir";
            }
            message = Iteration.uistrs().get(message,dir.getPath());
            if (haltiferror) {
                clnt.problem(message, Project.MSG_ERR);
                throw new BuildException(message, clnt.getLocation());
            }
            if (fb.getIndex()<=FeedbackLevel.QUIET_INDEX) {//not-none|veryquiet
                clnt.problem(message, Project.MSG_WARN);
            }
            okidoki=false;
        }
        return okidoki;
    }


    private Mkdirs()
    {
    }
}


/* end-of-Mkdirs.java */