/**
 * $Id: LocalExecutionBubbleTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.Target;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.flowcontrol.call.AnyTargetCaller;
import  com.idaremedia.antx.flowcontrol.wrap.LocalExecutionBubble;
import  com.idaremedia.antx.ownhelpers.ProjectPropertiesNet;
import  com.idaremedia.antx.print.EchoItemsTask;
import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;


/**
 * Test suite for {@linkplain com.idaremedia.antx.flowcontrol.wrap.LocalExecutionBubble
 * LocalExecutionBubble} and
 * {@linkplain com.idaremedia.antx.flowcontrol.wrap.IsolatedTaskSet IsolatedTaskSet}.
 *
 * @since     JWare/AntX 0.1
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class LocalExecutionBubbleTest extends HTC
{
    /**
     * Initializes new LocalExecutionBubble test case.
     **/
    public LocalExecutionBubbleTest(String methodName)
    {
        super("LocalExecutionBubble::",methodName);
    }



    /**
     * Create full test suite for bubble test.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(LocalExecutionBubbleTest.class);
    }


    /**
     * Create baseline test suite (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("localcall.xml");
    }



    private void aboutToExecute(Project P)
    {
        P.setProperty("root.property","root.property");
        P.setUserProperty("root.user.property","root.user.property");

        assertNil(P.getReference("root.ref"));
        assertNil(P.getProperty("local.property"));
        assertNil(P.getProperty("local.user.property"));
    }



    private void finishExecute(Project P, boolean dumpLog)
    {
        if (dumpLog) {
            println("FUUUUULLLL LOG:",getFullLog());
        }
        assertNil(P.getReference("root.ref"), "root.ref(out)");
        assertNil(P.getProperty("local.property"), "local.property(out)");
        assertNil(P.getProperty("local.user.property"), "local.user.property(out)");
    }



    private EchoItemsTask newPrintTask(Project P)
    {
        Target target = (Target)P.getTargets().get("echoTarget");
        assertNotNil(target,"echoTarget");
        EchoItemsTask task = new EchoItemsTask();
        task.setOwningTarget(target);
        task.setProject(P);
        task.init();
        task.setProperties("all");
        task.setReferences("all");
        return task;
    }


    private AnyTargetCaller newCallTask(Project P)
    {
        Target target = (Target)P.getTargets().get("callTarget");
        assertNotNil(target,"callTarget");
        AnyTargetCaller task = new AnyTargetCaller(P, "callTarget");
        task.setOwningTarget((Target)P.getTargets().get(P.getDefaultTarget()));
        task.init();
        return task;
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
        Project P = getProject();
        assertNotNil(P.getReference(ProjectPropertiesNet.ANT_HELPER_REFID),"ant.ProjectHelper");
        Target target = (Target)P.getTargets().get(P.getDefaultTarget());
        assertNotNil(target,"Default Target");
    }


    public void testBaseline()
    {
        checkBaseline();
    }


    /**
     * Verify that a basic bubble will capture/restore properties and
     * references (as best can).
     **/
    public void testBubbleWrap_AntX04()
    {
        Project P = getProject();

        aboutToExecute(P);

        EchoItemsTask task = newPrintTask(P);
        Requester taskLink = new Requester.ForComponent(task);
        LocalExecutionBubble bubble = new LocalExecutionBubble();
        bubble.setCarefulObjectChecks(true);

        bubble.enter(taskLink);
          P.setProperty("local.property","local.property");
          P.setUserProperty("local.user.property","local.user.property");
          P.setProperty("root.property","local.property");
          P.setUserProperty("root.user.property","local.user.property");
          P.addReference("root.ref.0",new Long(1000));
          task.execute();
        bubble.leave(taskLink);

        task.execute();
        finishExecute(P,true);
    }



    /**
     * Verify that bubble work for task sets that include tasks that
     * will create sub or child projects.
     **/
    public void testBubbleWrapWithChildProject_AntX04()
    {
        Project P = getProject();

        aboutToExecute(P);

        AnyTargetCaller task = newCallTask(P);
        Requester taskLink = new Requester.ForComponent(task);
        LocalExecutionBubble bubble = new LocalExecutionBubble();
        bubble.setCarefulObjectChecks(true);

        bubble.enter(taskLink);
            P.setProperty("local.property","local.property");
            P.setUserProperty("local.user.property","local.user.property");
            P.setProperty("root.property","local.property");
            P.setUserProperty("root.user.property","local.user.property");
            P.addReference("root.ref.0",new Long(1000));
            task.execute();
        bubble.leave(taskLink);
        finishExecute(P,false);

        newPrintTask(P).execute();
        println("FUUUUULLLL LOG:",getFullLog());
    }



    public void testCallLocal_AntX04()
    {
        runTarget("testCallLocalTargets_AntX04");
    }

    public void testCallLocalParameterizedTargets_AntX04()
    {
        runTarget("testCallLocalParameterizedTargets_AntX04");
    }

    public void testCallLocalSteps_AntX04()
    {
        runTarget("testCallLocalSteps_AntX04");
    }

    public void testCallLocalParameterizedSteps_AntX04()
    {
        runTarget("testCallLocalParameterizedSteps_AntX04");
    }

    public void testCallLocalOverlayUndone_AntX04()
    {
        runTarget("testCallLocalOverlayUndone_AntX04");
    }

    public void testCallLocalOverlayUndoneSteps_AntX04()
    {
        runTarget("testCallLocalOverlayUndoneSteps_AntX04");
    }


    public void testIsolatedSimple_AntX04()
    {
        runTarget("testIsolatedSimple_AntX04");
    }

    public void testIsolatedWarnings_AntX04()
    {
        runTarget("testIsolatedWarnings_AntX04");
    }

    public void testNestedIsolatedBlocks_AntX04()
    {
        runTarget("testNestedIsolatedBlocks_AntX04");
    }

    public void testResetFixture_AntX04()
    {
        runTarget("testResetFixture_AntX04");
    }

    public void testWorksWithOverlay_AntX04()
    {
        runTarget("testWorksWithOverlay_AntX04");
    }
    
    public void testLocalsPushPopped_AntX05()
    {
        runTarget("testLocalsPushPopped_AntX05");
    }

    public void testIsolateLocalVars_AntX05()
    {
        runTarget("testIsolateLocalVars_AntX05");
    }
    
    public void testIsolateLocalProperties_AntX05()
    {
        runTarget("testIsolateLocalProperties_AntX05");
    }

    public void testBlockAllowsAllUnlessNamed_AntX05()
    {
        runTarget("testBlockAllowsAllUnlessNamed_AntX05");
    }
    
    public void testPassthruLocalProperties_AntX05()
    {
        runTarget("testPassthruLocalProperties_AntX05");
    }
    
    public void testConditionalFixture_AntX05()
    {
        runTarget("testConditionalFixture_AntX05");
    }
}


/* end-of-LocalExecutionBubbleTest.java */
