/**
 * $Id: EmitTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback.tests;

import  java.util.List;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.feedback.EmitTask EmitTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class EmitTaskTest extends EmitTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new EmitTaskTest testcase.
     **/
    public EmitTaskTest(String methodName)
    {
        super("EmitTask::",methodName);
    }


    /**
     * Create full test suite for ProtectedTaskSet.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(EmitTaskTest.class);
    }


    /**
     * Create baseline test suite for ProtectedTaskSet (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(EmitTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "emit.xml";
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void testEmptyOK()
    {
        runTarget("testEmptyOK");
    }

    public void testDefaultEchoesToAnt()
    {
        String log= runTarget("testDefaultEchoesToAnt");
        assertTrue(log.indexOf("log4j")>=0, "Log4j-message echoed to Ant");
    }

    public void testDefaultFroms()
    {
        String log = runTarget("testDefaultFroms");
        verifyOccurances(log,"From: ",getIntegerProperty("EmitCount"));
    }

    public void testDefaultFromsNoEcho()
    {
        String log = runEchoedTarget("testDefaultFromsNoEcho");
        verifyOccurances(log,"From: ",0);
        verifyOccurances(testAppender().getLog(),"From: ",getIntegerProperty("EmitCount"));
    }

    public void testFatalLevelIsPinnedInAnt()
    {
        String log = runEchoedTarget("testFatalLevelIsPinnedAnt",null);
        int N= getIntegerProperty("EmitCount");
        verifyOccurances(log,"From: Dead",N);
        verifyOccurances(testAppender().getLog(),"FATAL",N);
    }

    public void testEmitAllMsgLevels()
    {
        String log = runEchoedTarget("testEmitAllMsgLevels");
        int N= getIntegerProperty("EmitCount");
        verifyOccurances(log,"Helloworld",4);//FATAL+ERR+WARN+INFO
        String log4jLog= testAppender().getLog();
        verifyOccurances(log4jLog,"Helloworld",N);
        verifyOccurances(log4jLog,"FATAL",1);
        verifyOccurances(log4jLog,"DEBUG",1);
        verifyOccurances(getFullLog(),"Helloworld",N);
    }

    public void testTimestamping()
    {
        String today = getTodayString();
        println("TODAY = ("+today+")");

        String log = runEchoedTarget("testTimestamping");
        String fullLog = getFullLog();
        String log4jLog= testAppender().getLog();

        int N= getIntegerProperty("EmitCount");

        verifyOccurances(fullLog,"Helloworld from task (",N);
        verifyOccurances(fullLog,"{2}", 0);
        verifyOccurances(log,"Helloworld from task (",1);
        verifyOccurances(log,today,1);
        verifyOccurances(log4jLog,"Helloworld from task (",N);
        verifyOccurances(log4jLog,today,N);
        verifyOccurances(log4jLog,"{2}", 0);
    }

    public void testTimestampingWithArgSubstitution()
    {
        String today = getTodayString();
        println("TODAY = ("+today+")");

        String log = runEchoedTarget("testTimestampAndArgSubstitution");
        String log4jLog= testAppender().getLog();

        int N= getIntegerProperty("EmitCount");

        verifyOccurances(log,"Timeworld from task (emit_) on the",N);
        verifyOccurances(log,today,N);

        verifyOccurances(log4jLog,"Timeworld from task (emit_) on the",N);
        verifyOccurances(log4jLog,today,N);

        verifyOccurances(log4jLog,"{2}", 0);
        verifyOccurances(log4jLog,"Felix",1);
        verifyOccurances(log4jLog,"Murphy",1);
        verifyOccurances(log4jLog,"Bob",1);
        verifyOccurances(log4jLog,"Janet",1);
        verifyOccurances(log4jLog,"1starg=()",1);
        verifyOccurances(log4jLog,"2ndarg=({4})",1);
    }

    public void testEmitThrownExceptions()
    {
        String log = runEchoedTarget("testEmitThrownExceptions",null);
        assertTrue(log.indexOf("Something went BoINk")>=0, "Emitted Exception Info");
        String log4jLog= testAppender().getLog();
        assertTrue(log4jLog.indexOf("Something went BoINk")>=0, "Emitted Exception Info to Log4J");
    }


    private void verifyPropertiesEmitted()
    {
        //NB: we can't verify ordering since it's arbitrary from
        //    the snapshot's underlying captured properties map...
        String log4jLog= testAppender().getLog();
        List namelist = Tk.splitList(getProject().getProperty("echo.props"),",");
        int N= getIntegerProperty("EmitCount");
        for (int i=0,M=namelist.size();i<M;i++) {
            verifyOccurances(log4jLog,(String)namelist.get(i),N);
        }
    }

    public void testEmitSelectProperties()
    {
        runEchoedTarget("testEmitSelectProperties");
        verifyPropertiesEmitted();
    }

    public void testEmitNestedProperties()
    {
        runEchoedTarget("testEmitNestedProperties");
        verifyPropertiesEmitted();
    }

    public void testEmitCombinationProperties()
    {
        runEchoedTarget("testEmitComboProperties");
        verifyPropertiesEmitted();
        verifyOccurances(testAppender().getLog(),"exportedVariable=phffht",1);
    }

    /** @since JWare/AntX 0.4 **/
    public void testEmitFromPrinterRegistry_AntX04()
    {
        String log= runEchoedTarget("testEmitFromPrinterRegistry_AntX04");
        assertTrue(log.indexOf("HelloFromPrinterRegistryEnabledWorld")>=0,"Emitted comment bits");
        String log4jLog = testAppender().getLog();
        assertTrue(log4jLog.indexOf("ThroatWobblerMangrove")>=0,"Emitted TWMangrove bits to Log4J");
    }
}

/* end-of-EmitTaskTest.java */
