/**
 * $Id: CheckpointTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 *  Class test for {@linkplain com.idaremedia.antx.feedback.CheckpointTask
 * CheckpointTask}.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class CheckpointTaskTest extends EmitTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new CheckpointTaskTest testcase.
     **/
    public CheckpointTaskTest(String methodName)
    {
        super("CheckpointTask::",methodName);
    }


    /**
     * Create full test suite for ProtectedTaskSet.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(CheckpointTaskTest.class);
    }


    /**
     * Create baseline test suite for ProtectedTaskSet (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "cp.xml";
    }

    private void verifyNoAntLogs(int i, int j)
    {
        String log = getLog();
        verifyOccurances(log,"Helloworld",i);
        verifyOccurances(log,"Howdy!",i);
        verifyOccurances(log,"Hello poo-poo",i);

        String fullLog = getFullLog();
        verifyOccurances(fullLog,"Helloworld",j);
        verifyOccurances(fullLog,"Howdy!",j);
        verifyOccurances(fullLog,"Hello poo-poo",j);
    }

    private void verifyNoLog4jLog(int i)
    {
        String log4jLog= testAppender().getLog();
        verifyOccurances(log4jLog,"Helloworld",i);
        verifyOccurances(log4jLog,"Howdy!",i);
        verifyOccurances(log4jLog,"Hello poo-poo",i);
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void testCheckpoints_AntX03()
    {
        runEchoedTarget("testCheckpoints_AntX03");
        verifyNoAntLogs(0,0);
        verifyNoLog4jLog(1);
    }

    public void testCheckpointsIfUnless_AntX03()
    {
        runEchoedTarget("testCheckpointsIfUnless_AntX03");
        verifyNoAntLogs(0,0);
        verifyNoLog4jLog(0);
    }

    public void testCheckpointsToFile_AntX03()
    {
        runEchoedTarget("testCheckpointsToFile_AntX03");
        verifyNoLog4jLog(0);
    }
    
    public void testCheckpointNoSourceLabel_AntX05()
    {
        final String targetName = "testCheckpointNoSourceLabel_AntX05";
        runEchoedTarget(targetName);
        String log = getLog();
        verifyOccurances(log,targetName,0);
        String log4jLog= testAppender().getLog();
        verifyOccurances(log4jLog,targetName,0);
    }
}

/* end-of-CheckpointTaskTest.java */
