/**
 * $Id: EmitConfiguration.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback;

import  com.idaremedia.apis.DiagnosticsEmitter;

import  com.idaremedia.antx.NoiseLevel;

/**
 * Configuration information provided to {@linkplain EmitConfigurable} components.
 * Configuration instances are both a source of default emit setup instructions as well
 * as a DiagnosticsEmitter factory.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 * @see      EmitContext
 **/

public interface EmitConfiguration
{
    /**
     * Returns the default grouping with which all messages sent
     * from this configuration are associated. Returns <i>null</i>
     * or the empty string if no such grouping.
     * @since JWare/AntX 0.3
     **/
    String getFrom();


    /**
     * Returns the default grouping path separator string for
     * this configuration. Most configurations use the period
     * (&#46;) to separate grouping items.
     * @since JWare/AntX 0.3
     **/
    String getGroupingPathSeparator();


    /**
     * Returns the default noise or priority level for this
     * configuration. Can return <i>null</i> if this configuration
     * has no custom level. Caller is free to use either some
     * default configuration or a project-based default.
     **/
    NoiseLevel getNoiseLevel();


    /**
     * Returns <i>true</i> if emitted messages should be echoed
     * to the standard Ant logging system.
     **/
    boolean shouldEcho();


    /**
     * Returns <i>true</i> if timestamp information should be
     * included with emitted messages.
     **/
    boolean wantTimestamp();


    /**
     * Updates the name list of properties to be included with any
     * messages. Returns <i>false</i> if no special properties have
     * been included.
     **/
    boolean getPropertiesNameList(StringBuffer list);


    /**
     * Returns this configuration's default diagnostics emitter.
     * Should never return <i>null</i>.
     **/
    DiagnosticsEmitter getEmitter();


    /**
     * Returns a specific diagnostics emitter from this configuration.
     * Should never return <i>null</i>.
     * @param grpId grouping path (like log4j's category name)
     **/
    DiagnosticsEmitter getCustomEmitter(String grpId);


    /**
     * Returns a configuration-formatted date/time string of
     * given timestamp.
     * @param ms timestamp as milliseconds since Jan 1st, 1970
     **/
    String stampify(long ms);
}


/* end-of-EmitConfiguration.java */
