/**
 * $Id: Emit.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback;

import  java.io.ByteArrayOutputStream;
import  java.io.IOException;

import  com.idaremedia.apis.DiagnosticsEmitter;
import  com.idaremedia.antx.ErrorSnapshot;
import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.helpers.Tk;
import com.idaremedia.antx.print.DisplayRequest;
import  com.idaremedia.antx.print.ErrorPrinter;

/**
 * Helper utilities to translate AntX NoiseLevel and ErrorSnapshots to a
 * DiagnosticsEmitter's implementation APIs.
 *
 * @since    JWare/AntX 0.3 (Moved out of EmitTask)
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 **/

public final class Emit
{
    /**
     * Route an emitted message to the diagnostics emitter's
     * (typically a log4j Logger) appropriate API.
     * @param broadcaster the diagnostics emitter (non-null)
     * @param msg what's to be set or emitted (<em>in final form</em>)(non-null)
     * @param t [optional] exception that caused this broadcast (can be null)
     * @param nl the associated priority of this message (non-null)
     * @see ErrorSnapshotRenderer
     **/
    public static final void broadcast(DiagnosticsEmitter broadcaster,
                               Object msg, Throwable t, NoiseLevel nl)
    {
        switch (nl.getIndex()) {
            case NoiseLevel.FATAL_INDEX:
                broadcaster.failure(t,msg); break;
            case NoiseLevel.ERROR_INDEX:
                broadcaster.error(t,msg);   break;
            case NoiseLevel.WARNING_INDEX:
                broadcaster.warning(t,msg); break;
            case NoiseLevel.INFO_INDEX:
                broadcaster.note(msg);      break;
            case NoiseLevel.VERBOSE_INDEX:
                broadcaster.note(msg);      break;
            default: //NoiseLevel.DEBUG_INDEX
                broadcaster.finetrace(t,msg);
        }
    }


    /**
     * Returns a standard string description of given object (usually
     * an error snapshot). The returned string is formatted like that
     * returned by the AntX {@linkplain ErrorPrinter ErrorPrinter}
     * display helper.
     * @return formatted string (non-null)
     **/
    public static final String stringify(Object object)
    {
        if (object instanceof ErrorSnapshot) {
            ErrorSnapshot es = (ErrorSnapshot)object;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
                DisplayRequest dr = new DisplayRequest(es);
                new ErrorPrinter().print(dr,bos);
                String s = bos.toString();
                bos.close();
                bos = null;
                return s;
            } catch(IOException ioX) {
                return es.toString();
            }
        }
        return Tk.stringFrom(object,null);
    }


    /**
     * Not-allowed.
     **/
    private Emit()
    { }
}

/* end-of-Emit.java */
