/**
 * $Id: RuleMacroDef.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Task;
import  org.apache.tools.ant.taskdefs.MacroDef;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.starters.MacroMaker;

/**
 * Macro maker that enforces a macro's definition to constraints of an AntX build rule.
 * However, unlike an AntX build rule, you can include batch checks in a rule macrodef.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 * @.pattern GoF.Proxy
 * @see      BuildRule
 **/

public final class RuleMacroDef extends MacroMaker
{
    private static final String IAM_= AntX.conditions+"rulemacro";

    /**
     * Initializes a new rule macro instance.
     **/
    public RuleMacroDef()
    {
        super(IAM_);
    }


    /**
     * Initializes a new enclosed macro instance.
     * @param iam CV-label (non-null)
     **/
    public RuleMacroDef(String iam)
    {
        super(iam);
    }


    /**
     * Adds a new attribute definition to this rule macro.
     * @param attr the attribute definition (non-null)
     **/
    public final void addConfiguredAttribute(MacroDef.Attribute attr)
    {
        addMacroParameter(attr);
    }


    /**
     * Returns the supposed effect if this macro evaluates
     * <i>false</i>. Should be called after this rule is fully
     * configured.
     **/
    public NoiseLevel getFailureEffect()
    {
        return m_failureEffect;
    }


    /**
     * Allows only sub-rules (of single effect) to this rule macro. If
     * the new item is the first sub-rule defined, it determines the kind
     * of subsequent sub-rules allowed. If the item is a rule, it must
     * be of the expected (dominant) type. Note that fixture checks are
     * always allowed.
     * @param taskClass class of task to be instantiated in macro instance
     * @param taskProxy task proxy (UnknownElement), non-null
     * @throws BuildException if task of wrong kind
     **/
    protected boolean includeTask(Class taskClass, Task taskProxy)
        throws BuildException
    {
        if (VerifyFixture.class.isAssignableFrom(taskClass)) {//always
            return true;
        }

        boolean isRequire = isRequireType(taskClass);
        boolean isPrefer  = !isRequire && PreferTask.class.isAssignableFrom(taskClass);

        if (!isRequire && !isPrefer) {
            return false;
        }

        if (m_failureEffect!=null) {
            BuildRule.checkAcceptable(this,isRequire,m_failureEffect);
        } else if (isRequire) {
            m_failureEffect = NoiseLevel.ERROR;
        } else {
            m_failureEffect = NoiseLevel.WARNING;
        }

        return true;
    }



    private boolean isRequireType(Class taskClass)
    {
        return AssertTask.class.isAssignableFrom(taskClass) ||
               BatchChecksTaskSet.class.isAssignableFrom(taskClass);
    }


    private NoiseLevel m_failureEffect=null;//NB: unknown->defined by 1st subrule
}

/* end-of-RuleMacroDef.java */
