/**
 * $Id: FixtureIds.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

/**
 * AntX's public iteration and project configuration category identifiers.
 *
 * @since    JWare/AntX 0.1 (originally IterationProperties)
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,infra
 * @see      FixtureOverlays
 **/

public class FixtureIds
{
    /**
     * Prefix for all global iteration properties.
     * @since JWare/AntX 0.4
     **/
    public static final String PREFIX =
        AntX.ANTX_INTERNAL_ID+"fixture.";


    /**
     * EmitConfiguration Instance.
     **/
    public static final String EMIT_CONFIGURATION =
        PREFIX+"EmitConfiguration";


    /**
     * UIStringManager Instance.
     **/
    public static final String MSGS_STRINGMANAGER =
        PREFIX+"UIStringManager";


    /**
     * Printer Registry Instance.
     * @since JWare/AntX 0.2
     **/
    public static final String PRINTER_REGISTRY =
        PREFIX+"PrinterRegistry";


    /**
     * General captured logs administration.
     * @since JWare/AntX 0.4
     **/
    public static final String CAPTURED_LOG_OUTPUTS =
        PREFIX+"CapturedLogOutputs";


    /**
     * Standard System output LogRecorder Instance.
     * @since JWare/AntX 0.3
     **/
    public static final String SYSTEM_STREAMS_RECORDER =
        PREFIX+"SystemStreamsRecorder";


    /**
     * Ant logs LogsRecorder Instance.
     * @since JWare/AntX 0.2
     **/
    public static final String ANT_LOGS_RECORDER =
        PREFIX+"AntLogsRecorder";


    /**
     * Uncaught ProblemHandler administration.
     * @since JWare/AntX 0.3
     **/
    public static final String PROBLEM_ADMINISTRATION =
        PREFIX+"ProblemHandler";


    /**
     * TaskExaminer Utility.
     * @since JWare/AntX 0.4
     **/
    public static final String TASK_EXAMINER =
        PREFIX+"TaskExaminer";


    /**
     * Mutable Properties Utilities.
     * @since JWare/AntX 0.4
     **/
    public static final String VARIABLES_ADMINISTRATION =
        PREFIX+"ExportedProperties";


    /**
     * AntX value URI property value interpreter.
     * @since JWare/AntX 0.5
     **/
    public static final String VALUEURI_INTERPRETER =
        PREFIX+"ValueUriInterperter";


    /**
     * AntX iteration fixture overlays administration.
     * @since JWare/AntX 0.5
     **/
    public static final String FIXTURE_OVERLAYS =
        PREFIX+"FixtureOverlays";



    /**
     * Allows extension of list of iteration-based elements.
     **/
    protected FixtureIds()
    { }
}

/* end-of-FixtureIds.java */
