/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupMetadata;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class ObjectGroupMetadataDeclarations
extends StreamObject {
    public List<ObjectGroupMetadata> objectGroupMetadataList = new ArrayList<ObjectGroupMetadata>();

    public ObjectGroupMetadataDeclarations() {
        super(StreamObjectTypeHeaderStart.ObjectGroupMetadataDeclarations);
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        if (this.objectGroupMetadataList != null) {
            for (ObjectGroupMetadata objectGroupMetadata : this.objectGroupMetadataList) {
                byteList.addAll(objectGroupMetadata.serializeToByteList());
            }
        }
        return 0;
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        int headerLength;
        if (lengthOfItems != 0) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "ObjectGroupMetadataDeclarations", "Stream object over-parse error", null);
        }
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        this.objectGroupMetadataList = new ArrayList<ObjectGroupMetadata>();
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            index.addAndGet(headerLength);
            if (header.get().type == StreamObjectTypeHeaderStart.ObjectGroupMetadata) {
                this.objectGroupMetadataList.add((ObjectGroupMetadata)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new StreamObjectParseErrorException(index.get(), "ObjectGroupDeclarations", "Failed to parse ObjectGroupMetadataDeclarations, expect the inner object type ObjectGroupMetadata, but actual type value is " + (Object)((Object)header.get().type), null);
        }
        currentIndex.set(index.get());
    }
}

