/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.fop;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.fop.JEuclidObj;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class JEuclidElement
extends JEuclidObj {
    private Point2D size;
    private Length baseline;
    private final MutableLayoutContext layoutContext = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());

    public JEuclidElement(FONode fONode) {
        super(fONode);
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        super.processNode(string, locator, attributes, propertyList);
        Document document = this.createBasicDocument();
        Element element = document.getDocumentElement();
        for (Parameter parameter : Parameter.values()) {
            String string2 = parameter.getOptionName();
            String string3 = "jeuclid:" + string2;
            String string4 = element.getAttributeNS("http://jeuclid.sf.net/ns/ext", string2);
            if (string4 != null && string4.length() != 0) continue;
            element.setAttributeNS("http://jeuclid.sf.net/ns/ext", string3, parameter.toString(this.layoutContext.getParameter(parameter)));
        }
    }

    private void calculate() {
        JEuclidView jEuclidView = new JEuclidView((Node)this.doc, (LayoutContext)this.layoutContext, null);
        float f = jEuclidView.getDescentHeight();
        this.size = new Point2D.Float(jEuclidView.getWidth(), jEuclidView.getAscentHeight() + f);
        this.baseline = FixedLength.getInstance((double)(-f), (String)"pt");
    }

    public Point2D getDimension(Point2D point2D) {
        if (this.size == null) {
            this.calculate();
        }
        return this.size;
    }

    public Length getIntrinsicAlignmentAdjust() {
        if (this.baseline == null) {
            this.calculate();
        }
        return this.baseline;
    }

    protected PropertyList createPropertyList(PropertyList propertyList, FOEventHandler fOEventHandler) throws FOPException {
        Color color;
        Color color2;
        FOUserAgent fOUserAgent = this.getUserAgent();
        CommonFont commonFont = propertyList.getFontProps();
        float f = (float)(commonFont.fontSize.getNumericValue() / 1000.0);
        Property property = propertyList.get(72);
        if (property != null) {
            color2 = property.getColor(fOUserAgent);
            this.layoutContext.setParameter(Parameter.MATHCOLOR, (Object)color2);
        }
        if ((color2 = propertyList.get(9)) != null) {
            color = color2.getColor(fOUserAgent);
            this.layoutContext.setParameter(Parameter.MATHBACKGROUND, (Object)color);
        }
        color = this.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = commonFont.getFontState((FontInfo)color);
        this.layoutContext.setParameter(Parameter.MATHSIZE, (Object)Float.valueOf(f));
        List list = (List)this.layoutContext.getParameter(Parameter.FONTS_SERIF);
        ArrayList<String> arrayList = new ArrayList<String>(fontTripletArray.length + list.size());
        for (FontTriplet fontTriplet : fontTripletArray) {
            arrayList.add(fontTriplet.getName());
        }
        arrayList.addAll(list);
        this.layoutContext.setParameter(Parameter.FONTS_SERIF, arrayList);
        return super.createPropertyList(propertyList, fOEventHandler);
    }
}

