/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.util;

import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;

public final class XLinks {
    private XLinks() {
    }

    public static boolean isComment(@Nullable XLink xlink) {
        if (xlink == null) {
            return false;
        }
        String role = xlink.getContentRole();
        return "Comment".equals(role) || "File Attachment".equals(role) || "Workflow".equals(role) || "archive-Comment".equals(role) || "archive-File Attachment".equals(role) || "archive-Workflow".equals(role) || ("Documentation-Release".equals(role) || "archive-Documentation-Release".equals(role)) && xlink.getStatus() != null;
    }

    public static boolean isArchived(@Nullable XLink xlink) {
        String role = xlink == null ? null : xlink.getContentRole();
        return role != null && (role.startsWith("archive-") || "Archive".equals(role));
    }

    public static boolean areAttached(@Nullable XLink xlink1, @Nullable XLink xlink2) {
        if (xlink1 == null || xlink2 == null) {
            return false;
        }
        for (XLinkForAttachedXLink att : xlink1.getAttached()) {
            if (att.getAttachedXLink().getId() != xlink2.getId()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDraft(@Nullable XLink xlink) {
        return xlink != null && xlink.getAccepted() == false && xlink.getAuthorOnly() != false;
    }

    public static XLink getThreadRoot(XLink xlink) {
        XLink root = xlink;
        Iterator<XLink> thread = xlink.getReplyTos();
        if (thread.hasNext()) {
            root = thread.next();
        }
        return root;
    }

    public static boolean isVersion(@Nullable XLink xlink) {
        if (xlink == null) {
            return false;
        }
        String role = xlink.getContentRole();
        return "Documentation-Release".equals(role) || "Documentation-Version".equals(role);
    }

    public static boolean isEditNote(@Nullable XLink xlink) {
        if (xlink == null) {
            return false;
        }
        String role = xlink.getContentRole();
        return "Documentation-Note".equals(role) || "archive-Documentation-Note".equals(role);
    }

    public static boolean isWorkflow(@Nullable XLink xlink) {
        if (xlink == null) {
            return false;
        }
        String role = xlink.getContentRole();
        return ("Workflow".equals(role) || "Documentation-Release".equals(role) || "archive-Workflow".equals(role) || "archive-Documentation-Release".equals(role)) && xlink.getStatus() != null;
    }
}

