/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.util;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.ObjectProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class URIs {
    private URIs() {
    }

    public static boolean matchesPSSourcePath(String path) {
        String psprefix = GlobalSettings.getSitePrefix();
        return path.startsWith(psprefix + "/ui/") || path.startsWith(psprefix + "/uri/") || path.startsWith(psprefix + "/docid/") || path.startsWith(psprefix + "/service/");
    }

    public static boolean isURLPSSource(@Nullable URI uri) {
        if (uri == null) {
            return false;
        }
        Host h = uri.getHost();
        if (h == null || h.isExternal()) {
            return false;
        }
        String path = uri.getPath();
        return URIs.matchesPSSourcePath(path);
    }

    public static boolean isExternal(@Nullable URI uri) {
        if (uri == null) {
            return false;
        }
        Host h = uri.getHost();
        if (h != null && h.isExternal()) {
            return true;
        }
        return !uri.getPath().startsWith(GlobalSettings.getSitePrefix()) || URIs.matchesPSSourcePath(uri.getPath());
    }

    public static String getURIString(URI uri) {
        Host host = uri.getHost();
        StringBuilder url = new StringBuilder();
        url.append(uri.getScheme()).append(':');
        if (!"mailto".equals(uri.getScheme())) {
            url.append("//");
        }
        if (host != null) {
            url.append(host.getName());
        }
        if (uri.getPort() != null && Rules.getDefaultPort((String)uri.getScheme()) != uri.getPort()) {
            url.append(':').append(uri.getPort());
        }
        if (uri.getPath() != null) {
            url.append(URIs.getURIPathForOutput(uri));
        }
        return url.toString();
    }

    public static String getURIPathForOutput(URI uri) {
        Map<String, List<String>> props;
        if (uri.getPath().indexOf(63) == -1) {
            return uri.getPath();
        }
        XLink xlink = uri.getXLink();
        if (xlink == null) {
            return uri.getPath();
        }
        ArrayList<XLink> replies = new ArrayList<XLink>(xlink.getRepliesCol());
        Collections.reverse(replies);
        for (XLink reply : replies) {
            if (reply.getStatus() != null && "Documentation-Old".equals(reply.getStatus())) continue;
            xlink = reply;
            break;
        }
        if ((props = ObjectProperties.toMap(xlink.getProperties())).containsKey("origpath")) {
            List<String> p = props.get("origpath");
            return p.isEmpty() ? uri.getPath() : p.iterator().next();
        }
        return uri.getPath();
    }

    public static boolean canBeIndexedAsURL(@Nullable URI uri) {
        if (!URIs.isExternal(uri) || URIs.isURLPSSource(uri)) {
            return false;
        }
        return !uri.isFolder();
    }
}

