/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.util;

import com.pageseeder.common.util.Hex;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jdo.Query;
import org.eclipse.jdt.annotation.Nullable;

public final class Authenticators {
    private Authenticators() {
    }

    public static List<Authenticator> listAuthenticatorsForMember(Database db, long memberId) throws QueryFailedException {
        ArrayList<Authenticator> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Authenticator.class, "this.member.id == memid");
            try {
                q.declareParameters("Long memid");
                arrayList = new ArrayList<Authenticator>((Collection)q.execute((Object)memberId));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<Authenticator> listAuthenticatorsForMemberType(Database db, long memberId, String type) throws QueryFailedException {
        ArrayList<Authenticator> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Authenticator.class, "this.type == type && this.member.id == memid");
            try {
                q.declareParameters("String type, Long memid");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("type", type);
                parameters.put("memid", memberId);
                arrayList = new ArrayList<Authenticator>((Collection)q.executeWithMap(parameters));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<Authenticator> listVerifiedWebauthnAuthenticatorsByCredentialId(Database db, byte[] credentialId) throws QueryFailedException {
        ArrayList<Authenticator> arrayList;
        block8: {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT AuthenticatorID FROM AUTHENTICATOR WHERE Verified = '1' AND CredentialId = ");
            sql.append(Authenticators.binaryPrefix());
            sql.append(Hex.encode((byte[])credentialId));
            sql.append("'");
            Query q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            try {
                q.setClass(Authenticator.class);
                arrayList = new ArrayList<Authenticator>((List)q.execute());
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<Authenticator> listVerifiedAuthenticatorsForMember(Database db, long memberId) throws QueryFailedException {
        ArrayList<Authenticator> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Authenticator.class, "this.member.id == memid && this.verified");
            try {
                q.declareParameters("Long memid");
                arrayList = new ArrayList<Authenticator>((Collection)q.execute((Object)memberId));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static @Nullable Authenticator getVerifiedAuthenticatorForMemberCredentialId(Database db, long memberId, byte[] credentialId) throws QueryFailedException {
        Authenticator authenticator;
        block8: {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT AuthenticatorID FROM AUTHENTICATOR WHERE Verified = '1' AND CredentialId = ");
            sql.append(Authenticators.binaryPrefix());
            sql.append(Hex.encode((byte[])credentialId));
            sql.append("' AND MemberId = ");
            sql.append(memberId);
            Query q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            try {
                q.setClass(Authenticator.class);
                q.setUnique(true);
                authenticator = (Authenticator)q.execute();
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return authenticator;
    }

    public static @Nullable Authenticator getAuthenticator(Database db, long memberId, String publicId) throws QueryFailedException {
        Authenticator authenticator;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Authenticator.class, "this.publicId == pubid && this.member.id == memid");
            try {
                q.declareParameters("String pubid, Long memid");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("pubid", publicId);
                parameters.put("memid", memberId);
                q.setUnique(true);
                authenticator = (Authenticator)q.executeWithMap(parameters);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return authenticator;
    }

    public static @Nullable Authenticator getUnverifiedAuthenticator(Database db, long memberId, String publicId) throws QueryFailedException {
        Authenticator authenticator;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Authenticator.class, "this.publicId == pubid && this.member.id == memid && !this.verified");
            try {
                q.declareParameters("String pubid, Long memid");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("pubid", publicId);
                parameters.put("memid", memberId);
                q.setUnique(true);
                authenticator = (Authenticator)q.executeWithMap(parameters);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return authenticator;
    }

    private static String binaryPrefix() {
        String type = DatabaseQuery.getDatabaseType();
        return "postgresql".equalsIgnoreCase(type) ? "E'\\\\x" : "X'";
    }
}

