/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.util.Flags;
import org.eclipse.jdt.annotation.Nullable;

public enum Role {
    GUEST("Guest", "guest", "g", false, false),
    REVIEWER("Reviewer", "reviewer", null, false, false),
    CONTRIBUTOR("Contributor", "contributor", null, true, false),
    MANAGER("Manager", "manager", "e", true, false),
    MODERATOR("Moderator", "moderator", "e", true, true),
    APPROVER("Approver", "approver", "ae", true, false),
    MODERATOR_AND_APPROVER("Mod & App", "moderator-and-approver", "ae", true, true);

    private static final char[] EDITOR_FLAGS;
    private final String title;
    private final String attribute;
    private final @Nullable String editorFlags;
    private final boolean isEditor;
    private final boolean isModerator;

    private Role(@Nullable String title, String attribute, String editorFlags, boolean isEditor, boolean isModerator) {
        this.title = title;
        this.attribute = attribute;
        this.editorFlags = editorFlags;
        this.isEditor = isEditor;
        this.isModerator = isModerator;
    }

    public String title() {
        return this.title;
    }

    public String attribute() {
        return this.attribute;
    }

    public boolean isEditor() {
        return this.isEditor;
    }

    public boolean isModerator() {
        return this.isModerator;
    }

    public @Nullable String updateFlags(@Nullable String flags) {
        String updated = flags != null ? flags : "";
        for (char c : EDITOR_FLAGS) {
            updated = this.editorFlags != null && this.editorFlags.indexOf(c) != -1 ? Flags.add(updated, c) : Flags.remove(updated, c);
        }
        return updated;
    }

    public boolean matchFlags(@Nullable String flags) {
        if (this.editorFlags == null && flags == null) {
            return true;
        }
        for (char c : EDITOR_FLAGS) {
            boolean hasFlag;
            boolean requiresFlag = this.editorFlags != null && this.editorFlags.indexOf(c) != -1;
            boolean bl = hasFlag = flags != null && flags.indexOf(c) != -1;
            if (requiresFlag == hasFlag) continue;
            return false;
        }
        return true;
    }

    public @Nullable String getFlags() {
        return this.editorFlags;
    }

    public boolean hasFlag(char flag) {
        return this.editorFlags != null && this.editorFlags.indexOf(flag) != -1;
    }

    public static @Nullable Role forTitle(String title) {
        for (Role r : Role.values()) {
            if (!r.title().equals(title)) continue;
            return r;
        }
        return null;
    }

    public static @Nullable Role forAttribute(String attribute) {
        for (Role r : Role.values()) {
            if (!r.attribute().equals(attribute)) continue;
            return r;
        }
        return null;
    }

    public static @Nullable Role forFlagsEditorModerator(String flags, boolean editor, boolean moderator) {
        for (Role r : Role.values()) {
            if (editor != r.isEditor() || moderator != r.isModerator() || !r.matchFlags(flags)) continue;
            return r;
        }
        return null;
    }

    static {
        EDITOR_FLAGS = new char[]{'a', 'e', 'g'};
    }
}

