/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.model.Host;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;

public final class GroupURI
extends DBObject
implements Persistable {
    private String scheme;
    private String path;
    private Collection<GroupURIForGroup> groups = new HashSet<GroupURIForGroup>();
    private Host host;
    private Integer port;
    private Long id;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = GroupURI.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = GroupURI.__dnGetInheritedFieldCount();

    @Override
    public Long getId() {
        return GroupURI.dnGetid(this);
    }

    public static GroupURI create(Database db) throws CreateFailedException {
        return new GroupURI();
    }

    @Override
    public GroupURI insert(Database db) throws InsertFailedException {
        return (GroupURI)super.insert(db);
    }

    public String getScheme() {
        return GroupURI.dnGetscheme(this);
    }

    public String getPath() {
        return GroupURI.dnGetpath(this);
    }

    public Integer getPort() {
        return GroupURI.dnGetport(this);
    }

    public void setPort(Integer newPort) {
        GroupURI.dnSetport(this, newPort);
    }

    public void setScheme(String newScheme) {
        GroupURI.dnSetscheme(this, Helper.ensureNotEmpty(newScheme));
    }

    public void setPath(String newPath) {
        GroupURI.dnSetpath(this, Helper.ensureNotEmpty(newPath));
    }

    public Host getHost() {
        return GroupURI.dnGethost(this);
    }

    public void setHost(Host newHost) {
        GroupURI.dnSethost(this, newHost);
    }

    public boolean isExternal() {
        return GroupURI.isExternal(this);
    }

    public Iterator<Group> getGroups() {
        return this.getGroupsCol().iterator();
    }

    public Collection<GroupURIForGroup> getGroupURIForGroupsCol() {
        return new ArrayList<GroupURIForGroup>(GroupURI.dnGetgroups(this));
    }

    public Collection<Group> getGroupsCol() {
        ArrayList<Group> gps = new ArrayList<Group>();
        for (GroupURIForGroup gfg : GroupURI.dnGetgroups(this)) {
            gps.add(gfg.getGroup());
        }
        return gps;
    }

    public void addGroups(GroupURIForGroup newGroup) {
        GroupURI.dnGetgroups(this).add(newGroup);
    }

    public void removeGroups(GroupURIForGroup oldGroup) {
        GroupURI.dnGetgroups(this).remove(oldGroup);
    }

    public void removeGroups(@Nullable Group oldGroup) {
        if (oldGroup == null) {
            return;
        }
        GroupURIForGroup theone = null;
        for (GroupURIForGroup gfg : GroupURI.dnGetgroups(this)) {
            if (!gfg.getGroup().equals(oldGroup)) continue;
            theone = gfg;
            break;
        }
        if (theone != null) {
            GroupURI.dnGetgroups(this).remove(theone);
        }
    }

    public static boolean isExternal(@Nullable GroupURI guri) {
        if (guri == null) {
            return false;
        }
        Host h = guri.getHost();
        if (h != null && h.isExternal()) {
            return true;
        }
        int webPort = Settings.getDocumentPort();
        String webScheme = Settings.getDocumentScheme();
        return webPort != guri.getPort() || !webScheme.equals(guri.getScheme()) || !guri.getPath().startsWith(GlobalSettings.getSitePrefix());
    }

    static {
        EnhancementHelper.registerClass((Class)GroupURI.___dn$loadClass("com.pageseeder.db.model.GroupURI"), (Persistable)new GroupURI());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(2, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        GroupURI result = new GroupURI();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        GroupURI result = new GroupURI();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.groups = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.host = (Host)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.port = (Integer)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.scheme = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.groups);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.host);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.port);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.scheme);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(GroupURI obj, int index) {
        switch (index) {
            case 0: {
                this.groups = obj.groups;
                break;
            }
            case 1: {
                this.host = obj.host;
                break;
            }
            case 2: {
                this.id = obj.id;
                break;
            }
            case 3: {
                this.path = obj.path;
                break;
            }
            case 4: {
                this.port = obj.port;
                break;
            }
            case 5: {
                this.scheme = obj.scheme;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof GroupURI)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.GroupURI");
        }
        GroupURI other = (GroupURI)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"groups", "host", "id", "path", "port", "scheme"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 6;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Collection dnGetgroups(GroupURI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, objPC.groups);
        }
        return objPC.groups;
    }

    private static void dnSetgroups(GroupURI objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.groups = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, objPC.groups, (Object)val);
        }
    }

    private static Host dnGethost(GroupURI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Host)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.host);
        }
        return objPC.host;
    }

    private static void dnSethost(GroupURI objPC, Host val) {
        if (objPC.dnStateManager == null) {
            objPC.host = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.host, (Object)val);
        }
    }

    private static Long dnGetid(GroupURI objPC) {
        return objPC.id;
    }

    private static void dnSetid(GroupURI objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.id, (Object)val);
        }
    }

    private static String dnGetpath(GroupURI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.path);
        }
        return objPC.path;
    }

    private static void dnSetpath(GroupURI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.path, val);
        } else {
            objPC.path = val;
        }
    }

    private static Integer dnGetport(GroupURI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Integer)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.port);
        }
        return objPC.port;
    }

    private static void dnSetport(GroupURI objPC, Integer val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.port, (Object)val);
        } else {
            objPC.port = val;
        }
    }

    private static String dnGetscheme(GroupURI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.scheme);
        }
        return objPC.scheme;
    }

    private static void dnSetscheme(GroupURI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.scheme, val);
        } else {
            objPC.scheme = val;
        }
    }
}

