/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.db.Database;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.model.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Predicate {
    private String name = null;
    private String clause = null;
    private Map<String, Object> parameters = null;
    private String ordering = null;
    private int pageSize = -1;
    private int page = 1;
    private String result = null;
    private List<String> variables = null;
    private Map<String, PSQuery<? extends DBObject>> subqueries = null;
    private Map<PSQuery<? extends DBObject>, String> candidates = null;
    private final Database database;

    public Predicate(Database db) {
        this(db, null);
    }

    public Predicate(Database db, String n) {
        this.database = db;
        this.name = n;
    }

    public final String getName() {
        return this.name;
    }

    public final Predicate setPaging(int p, int ps) {
        this.page = p;
        this.pageSize = ps;
        return this;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final int getPage() {
        return this.page;
    }

    public final void setClause(String claus) {
        this.clause = claus;
    }

    public final void setOrdering(String order) {
        this.ordering = order;
    }

    public final void setResult(String res) {
        this.result = res;
    }

    public final Database getDatabase() {
        return this.database;
    }

    public final String getClause() {
        return this.clause;
    }

    public final String getOrdering() {
        return this.ordering;
    }

    public final String getResult() {
        return this.result;
    }

    public final void addParam(String param, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(param, value);
    }

    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final List<String> getVariables() {
        return this.variables;
    }

    public final void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        this.variables.add(variable);
    }

    public final Map<String, PSQuery<? extends DBObject>> getSubQueries() {
        return this.subqueries;
    }

    public final String getCandidate(PSQuery<? extends DBObject> query) {
        return this.candidates == null ? null : this.candidates.get(query);
    }

    public final void addSubQuery(PSQuery<? extends DBObject> subquery, String variable) {
        this.addSubQuery(subquery, variable, null);
    }

    public final void addSubQuery(PSQuery<? extends DBObject> subquery, String variable, String candidate) {
        if (this.subqueries == null) {
            this.subqueries = new HashMap<String, PSQuery<? extends DBObject>>();
        }
        this.subqueries.put(variable, subquery);
        if (candidate != null) {
            if (this.candidates == null) {
                this.candidates = new HashMap<PSQuery<? extends DBObject>, String>();
            }
            this.candidates.put(subquery, candidate);
        }
    }

    public final void addPredicate(Predicate pred) {
        Map<String, PSQuery<? extends DBObject>> predSubqueries;
        if (pred == null) {
            return;
        }
        if (pred.getName() != null || this.name != null) {
            this.name = (this.name == null ? "unkownPredicate" : this.name) + " + " + (pred.getName() == null ? "unkownPredicate" : pred.getName());
        }
        String string = this.clause == null ? pred.getClause() : (this.clause = pred.getClause() == null ? this.clause : "(" + this.clause + ") && (" + pred.getClause() + ")");
        if (this.ordering == null) {
            this.setOrdering(pred.getOrdering());
        }
        if (this.result == null) {
            this.setResult(pred.getResult());
        }
        if (this.parameters == null) {
            this.parameters = pred.getParameters();
        } else if (pred.getParameters() != null) {
            this.parameters.putAll(pred.getParameters());
        }
        if (this.variables == null) {
            this.variables = pred.getVariables();
        } else if (pred.getVariables() != null) {
            this.variables.addAll(pred.getVariables());
        }
        if (this.pageSize == -1) {
            this.setPaging(pred.getPage(), pred.getPageSize());
        }
        if ((predSubqueries = pred.getSubQueries()) != null) {
            for (Map.Entry<String, PSQuery<? extends DBObject>> entry : predSubqueries.entrySet()) {
                String key = entry.getKey();
                PSQuery<? extends DBObject> pq = entry.getValue();
                this.addSubQuery(pq, key, pred.getCandidate(pq));
            }
        }
    }

    public String toString() {
        return this.clause + (String)(this.parameters != null && !this.parameters.isEmpty() ? " (" + this.parameters.size() + " params)" : "");
    }
}

