/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.ws.Channel;
import com.pageseeder.ws.ChannelId;
import com.pageseeder.ws.Event;
import com.pageseeder.ws.FragmentEditingEvent;
import com.pageseeder.ws.Subscriber;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ChannelManager {
    private final Map<ChannelId, Channel> channels = new ConcurrentHashMap<ChannelId, Channel>();
    private static final ChannelManager SINGLETON = new ChannelManager();

    public static ChannelManager get() {
        return SINGLETON;
    }

    private ChannelManager() {
    }

    public ChannelId getId(Channel.Type type, long id) {
        ChannelId channelId = new ChannelId(type, id);
        Channel channel = this.channels.get(channelId);
        return channel != null ? channel.getId() : channelId;
    }

    public Channel register(ChannelId id) {
        return this.channels.computeIfAbsent(id, Channel::new);
    }

    public Channel registerAndSubscribe(ChannelId id, Subscriber<?> subscriber) {
        Channel channel = this.register(id);
        channel.subscribe(subscriber);
        return channel;
    }

    public Channel unregister(ChannelId id) {
        return this.channels.remove(id);
    }

    public Channel getChannel(ChannelId id) {
        return this.channels.get(id);
    }

    public void post(ChannelId id, Event event) {
        Channel channel = this.channels.get(id);
        if (channel != null) {
            channel.post(event.toMessage());
        }
    }

    public void unsubscribe(ChannelId channelId, Long subscriberId) {
        if (channelId == null) {
            return;
        }
        Channel channel = this.channels.get(channelId);
        if (channel != null) {
            channel.unsubscribe(subscriberId);
            if (channel.isEmpty()) {
                this.channels.remove(channelId);
            }
        }
    }

    public void publishFragmentEvent(long uriid, String fragment, Member author, XLink edit, String event) {
        Channel channel = this.channels.get(new ChannelId(Channel.Type.URI_EDITING, uriid));
        if (channel != null) {
            channel.post(new FragmentEditingEvent(uriid, fragment, author, edit, event).toMessage());
        }
    }
}

