/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.util.List;

@Requires(database=true, uri=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetURIVersions
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        if (pagesize < 1) {
            res.setError(GeneratorStatus.BAD_REQUEST, "pagesize must be larger than 0");
            return;
        }
        Database db = req.getDatabase();
        URI uri = req.getURI();
        assert (uri != null);
        URIRule.LimitReached limit = new URIRule.LimitReached();
        List versions = URIRule.getReleasesForURI((Database)db, (URI)uri, null, (int)page, (int)pagesize, (URIRule.LimitReached)limit);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("versions");
        if (limit.reached) {
            out.field("limitreached", true);
        }
        out.startCollection("versions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (XLink version : versions) {
            out.writeVersion(version);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

