/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class CreatePublicationVersionThread
extends ProcessThread {
    private static final int MAX_VERSION_NOTIFICATION_PSML = 20;
    private final Version version;
    private int total = 0;
    private int current = 0;
    private final Publication publication;

    public CreatePublicationVersionThread(String username, Group group, Publication pub, Version v) {
        super(username, "Creating version for publication " + pub.getId(), group);
        this.publication = pub;
        this.version = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Failed to open database: " + ex.getMessage());
            this.complete("");
            return;
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing documents to process");
        Transaction tr = new Transaction(db);
        boolean withWarnings = false;
        int nbcreated = 0;
        try {
            Group wgroup;
            Member author;
            tr.begin();
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member member = author = this.version.authorid == null ? null : DatabaseQuery.getMemberById((Database)db, (Long)this.version.authorid);
            if (author == null) {
                this.fail("Version has no valid author.");
                return;
            }
            Group group2 = wgroup = this.version.groupid == null ? null : DatabaseQuery.getGroupById((Database)db, (Long)this.version.groupid);
            if (wgroup == null) {
                this.fail("Version has no valid group.");
                return;
            }
            URI rootURI = DatabaseQuery.getURIById((Database)db, (Long)this.publication.getRootURIId());
            if (rootURI == null) {
                this.fail("Publication root URI " + this.publication.getRootURIId() + " is not a valid URI.");
                return;
            }
            Group pubGroup = PublicationManager.getDocumentGroup((Database)db, (URI)rootURI, (Group)DatabaseQuery.getGroupById((Database)db, (Long)this.publication.getDefaultGroupId()));
            Collection<URI> uris = new ArrayList<URI>();
            uris.add(rootURI);
            uris = this.findDescendants(db, rootURI, pubGroup, null, new ArrayList<DatabaseQuery.URIFragmentPair>(), uris);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + uris.size() + " documents.");
            XLink pubXLink = DatabaseQuery.getXLinkById((Database)db, (Long)this.publication.getXLinkId());
            int maxURIs = GlobalSettings.getInt((String)"maxVersionNotifications", (int)20);
            if (uris.size() > maxURIs && this.version.notify != Notify.SILENT) {
                this.version.notify = Notify.SILENT;
                this.updateStatus(ProcessStage.Status.WARNING, "The notify parameter will be ignored as there were more than " + maxURIs + " versions to create.");
                withWarnings = true;
            }
            this.total = uris.size() * 2;
            this.current = 0;
            HashMap<Long, Long> created = new HashMap<Long, Long>();
            for (URI psml : uris) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Creating version for URI " + psml.getDecodedPath());
                XLink xl = null;
                try {
                    xl = XLinkRule.createVersionXLink((Database)db, (URI)psml, (String)this.version.version, (XLink)pubXLink, (Member)author, (Date)this.version.createdate, (String[])this.version.labels, (String)this.version.content, (Group)wgroup, (Notify)this.version.notify, null);
                }
                catch (EmailException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "The version has been added, however it could not be emailed to other group members. Error: " + ex.getMessage());
                    withWarnings = true;
                }
                catch (FoundationException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, RuleUtils.defaultValue((String)ex.getMessage(), (String)"Failed to create version"));
                    withWarnings = true;
                }
                if (xl != null) {
                    created.put(psml.getId(), xl.getId());
                } else {
                    withWarnings = true;
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to create version");
                }
                if (this.wasCancelled()) {
                    tr.abort();
                    return;
                }
                if (this.current++ % 1000 != 0) continue;
                tr.commitAndStart();
            }
            nbcreated = created.size();
            if (this.wasCancelled()) {
                tr.abort();
                return;
            }
            tr.commitAndStart();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding documents to index queue.");
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch("Bulk version on publication " + this.publication.getId());
            changes.startBatch(db, batch);
            for (Long uriid : created.keySet()) {
                URI psml = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)((Long)created.get(uriid)));
                Collection gps = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)psml.getId());
                changes.createVersion(db, batch, psml, xl, gps);
                ++this.current;
            }
            changes.completeBatch(db, batch);
            tr.commit();
            this.current = this.total;
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (DatabaseException e) {
            this.fail("Failed to communicate with database: " + e.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            Object msg = nbcreated == 0 ? "No versions were created" : (nbcreated == 1 ? "1 version was successfully created" : nbcreated + " versions were successfully created - they will be available after indexing is completed");
            if (withWarnings) {
                this.fail((String)msg + " and there were some warnings and/or errors, see process logs for more details.");
            }
            this.complete((String)msg + ".");
        }
    }

    private Collection<URI> findDescendants(Database db, URI root, Group pubGroup, String fragment, Collection<DatabaseQuery.URIFragmentPair> ancestors, Collection<URI> descendants) {
        ancestors.add(new DatabaseQuery.URIFragmentPair(root.getId(), fragment));
        try {
            List xrefs = DatabaseQuery.getXRefsForwardURIGroupFragment((Database)db, (URI)root, (Group)GroupRule.getEditGroup((Database)db, (Group)pubGroup, (URI)root), (String)fragment);
            for (XLink xl : xrefs) {
                DatabaseQuery.URIFragmentPair targetPair;
                XRef xref = new XRef(xl);
                URI target = xref.getTargetURI();
                if (target == null) continue;
                if (!"none".equals(xref.getType()) && !descendants.contains(target)) {
                    descendants.add(target);
                }
                if (!"embed".equals(xref.getType()) && !"transclude".equals(xref.getType())) continue;
                String frag = xref.getTargetFragment();
                if ("default".equals(frag)) {
                    frag = null;
                }
                if (ancestors.contains(targetPair = new DatabaseQuery.URIFragmentPair(target.getId(), frag))) {
                    this.fail("XRef loop detected with URI " + target.getId() + " and fragment " + (frag == null ? "default" : frag));
                    return null;
                }
                this.findDescendants(db, target, pubGroup, frag, new ArrayList<DatabaseQuery.URIFragmentPair>(ancestors), descendants);
            }
        }
        catch (DatabaseException ex) {
            this.fail("Failed to load publication documents: " + ex.getMessage());
            return null;
        }
        return descendants;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.current);
        out.endObject();
    }

    public static final class Version {
        private final String version;
        private final Long authorid;
        private Date createdate;
        private String[] labels;
        private final boolean is_reviewer;
        private final Long groupid;
        private final String content;
        private Notify notify;

        public Version(String v, Member a, Date cd, boolean isr, Group grp, String c, String[] l, Notify n) {
            this.authorid = a.getId();
            this.createdate = cd;
            this.notify = n;
            this.is_reviewer = isr;
            this.content = c;
            this.groupid = grp.getId();
            this.labels = l;
            this.version = v;
        }
    }
}

