/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public final class ArchivePublicationVersionThread
extends ProcessThread {
    private final Long versionid;
    private int total = 0;
    private int current = 0;
    private final Publication publication;

    public ArchivePublicationVersionThread(String username, Group group, Publication pub, Long vid) {
        super(username, "Archiving version for publication " + pub.getId(), group);
        this.publication = pub;
        this.versionid = vid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Failed to open database: " + ex.getMessage());
            this.complete("");
            return;
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing versions to process");
        Transaction tr = new Transaction(db);
        int nbcreated = 0;
        try {
            tr.begin();
            Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername());
            if (member == null) {
                throw new DatabaseException("Member not found for username " + this.getUsername());
            }
            XLink version = DatabaseQuery.getXLinkById((Database)db, (Long)this.versionid);
            if (version == null) {
                throw new DatabaseException("Version not found for versionid " + this.versionid);
            }
            Collection xfaxs = DatabaseQuery.getXLinksForAttachedByAttachedToTitleCreated((Database)db, (Long)this.publication.getXLinkId(), (String)version.getContentTitle(), (Date)version.getDate());
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + xfaxs.size() + " versions.");
            this.total = xfaxs.size() * 2;
            Date date = new Date();
            this.current = 0;
            HashMap<Long, Long> created = new HashMap<Long, Long>();
            for (XLinkForAttachedXLink xfax : xfaxs) {
                XLink xl = xfax.getXLink();
                URI uri = URIRule.getURIByXLink((XLink)xl);
                if (uri == null) {
                    this.updateStatus(ProcessStage.Status.WARNING, "URI not found for version for ID " + xl.getId());
                } else {
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Archived version for ID " + xl.getId());
                    XLinkRule.archiveXLink((XLink)xl);
                    xl.setModifiedBy(member);
                    xl.setModifiedDate(date);
                    uri.setLastModified(new Date());
                    created.put(uri.getId(), xl.getId());
                }
                if (this.wasCancelled()) {
                    tr.abort();
                    return;
                }
                if (this.current++ % 1000 != 0) continue;
                tr.commitAndStart();
            }
            nbcreated = created.size();
            if (this.wasCancelled()) {
                tr.abort();
                return;
            }
            tr.commitAndStart();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding documents to index queue.");
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch("Archive version on publication " + this.publication.getId());
            changes.startBatch(db, batch);
            for (Long uriid : created.keySet()) {
                URI psml = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)((Long)created.get(uriid)));
                Collection gps = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)psml.getId());
                changes.archiveVersion(db, batch, psml, xl, gps);
                ++this.current;
            }
            changes.completeBatch(db, batch);
            tr.commit();
            this.current = this.total;
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (DatabaseException e) {
            this.fail("Failed to communicate with database: " + e.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            Object msg = nbcreated == 0 ? "No versions were archived" : (nbcreated == 1 ? "1 version was successfully archived" : nbcreated + " versions were successfully archived");
            if (this.hasWarning()) {
                this.fail((String)msg + " and there were some warnings, see process logs for more details.");
            }
            this.complete((String)msg + ".");
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.current);
        out.endObject();
    }
}

