/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.validation.CachedResults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.SVRLParser;

public class ValidationResults {
    private final CachedResults _results;
    private final boolean _cacheable;
    private final boolean _schemaNotFound;
    private final String _errorMessage;
    private List<String> _failedAssertions = null;
    private final boolean _urlMetadataRequested;

    public ValidationResults(String error, boolean schemaNotFound) {
        this._results = null;
        this._errorMessage = error;
        this._cacheable = false;
        this._schemaNotFound = schemaNotFound;
        this._urlMetadataRequested = false;
    }

    public ValidationResults(CachedResults results, boolean cacheable, boolean urlMetadataRequested) {
        this._results = results;
        this._errorMessage = null;
        this._cacheable = cacheable;
        this._schemaNotFound = false;
        this._urlMetadataRequested = urlMetadataRequested;
    }

    public String getSVRLResults() {
        return this._results == null ? null : new String(this._results.getSVRLResults(), StandardCharsets.UTF_8);
    }

    public boolean isValid() {
        return this._results != null && this._results.isValid();
    }

    public boolean hasError() {
        return !this.isValid();
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public List<String> listFailedAssertions() {
        if (this._failedAssertions == null) {
            this._failedAssertions = this.loadFailedAssertions();
        }
        return this._failedAssertions;
    }

    private List<String> loadFailedAssertions() {
        List<String> list;
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this._results.getSVRLResults()), StandardCharsets.UTF_8);
        try {
            list = SVRLParser.parse((Reader)reader).getFailedAsserts().stream().map(assertOrReport -> assertOrReport.getText().toPlainText()).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SchematronException ex) {
                return Collections.singletonList(ex.getMessage());
            }
        }
        reader.close();
        return list;
    }

    public boolean wasValidated() {
        return this._results != null;
    }

    public boolean areCacheable() {
        return this._cacheable;
    }

    public boolean wasSchemaNotFound() {
        return this._schemaNotFound;
    }

    public boolean urlMetadataRequested() {
        return this._urlMetadataRequested;
    }

    protected CachedResults getCachedResults() {
        return this._results;
    }
}

