/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.xml.Schematron;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.validation.CachedResults;
import com.pageseeder.validation.SchematronURIResolver;
import com.pageseeder.validation.ValidationResults;
import com.pageseeder.validation.Validators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronValidationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronValidationManager.class);
    private static final Pattern INCLUDES = Pattern.compile("include\\s+href=\"([^\"]+)\"");
    private static SchematronValidationManager INSTANCE;
    private final Map<String, Validator> validators = new HashMap<String, Validator>();
    private final Cache validationCache = CacheManager.getInstance().getCache("validation-results");

    private SchematronValidationManager() {
    }

    public static SchematronValidationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SchematronValidationManager();
        }
        return INSTANCE;
    }

    public ValidationResults getValidationResults(Group group, URI uri, Member member, Database db, Map<String, String> cache) {
        ValidationResults results;
        File schematron = Validators.findDefaultSchema(group, uri);
        if (schematron == null) {
            LOGGER.debug("Default schematron not found for URI {} in group {}", (Object)uri.getPath(), (Object)group.getName());
            return new ValidationResults("Default schematron not found", true);
        }
        String key = this.buildCacheKey(group, uri);
        long version = this.buildCacheVersion(uri, schematron);
        Element cached = this.validationCache.get((Serializable)((Object)key));
        if (cached != null) {
            if (cached.getVersion() == version) {
                return new ValidationResults((CachedResults)cached.getObjectValue(), true, false);
            }
            this.validationCache.remove((Serializable)((Object)key));
        }
        if ((results = this.validate(group, uri, schematron, member, db, cache)) != null && results.areCacheable()) {
            this.validationCache.put(new Element((Serializable)((Object)key), (Serializable)results.getCachedResults(), version));
        }
        return results;
    }

    public ValidationResults validate(Group group, URI uri, File schematron, Member member, Database db, Map<String, String> cache) {
        ValidationResults validationResults;
        block15: {
            Validator validator;
            if (schematron == null) {
                LOGGER.debug("Default schematron not found for URI {} in group {}", (Object)uri.getPath(), (Object)group.getName());
                return new ValidationResults("Default schematron not found", true);
            }
            LOGGER.debug("Validating {} with schema {} in {}", new Object[]{uri.getUserTitle(), schematron, group.getName()});
            try {
                validator = this.getValidator(schematron);
            }
            catch (SchematronException ex) {
                LOGGER.error("Failed to validate URI {} in {}", new Object[]{uri.getId(), group.getName(), ex});
                Object msg = ex.getMessage();
                if (msg != null && ((String)msg).startsWith("Unable to generate new Validator")) {
                    Throwable cause = ex.getCause();
                    msg = "Unable to generate schematron validator" + (String)(cause == null || cause.getMessage() == null ? "" : ": " + cause.getMessage());
                } else if (msg == null) {
                    msg = "Unable to create schematron validator";
                }
                return new ValidationResults("Failed to validate: " + (String)msg, false);
            }
            SchematronURIResolver uriresolver = new SchematronURIResolver(group, uri, member, db);
            uriresolver.setServerFromURI(uri);
            uriresolver.setResponseCache(cache);
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setPSMLFormat(true);
            InputStream content = resolver.getContent(db);
            try {
                StreamSource source = new StreamSource(content);
                source.setSystemId(URIRule.getURIString((URI)uri));
                SchematronResult result = validator.resolver((URIResolver)uriresolver).validate((Source)source);
                boolean cacheable = !uriresolver.wasUsed();
                validationResults = new ValidationResults(new CachedResults(result), cacheable, uriresolver.urlMetadataRequested());
                if (content == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SchematronException ex) {
                    LOGGER.error("Failed to validate URI {} in {}", new Object[]{uri.getId(), group.getName(), ex});
                    return new ValidationResults("Failed to validate: " + ex.getMessage(), false);
                }
                catch (URIException | IOException ex) {
                    LOGGER.error("Failed to load content for validation of URI {} in {}", new Object[]{uri.getId(), group.getName(), ex});
                    return new ValidationResults("Failed to load content: " + ex.getMessage(), false);
                }
            }
            content.close();
        }
        return validationResults;
    }

    private String buildCacheKey(Group group, URI uri) {
        return group.getName() + "-" + uri.getId();
    }

    private long buildCacheVersion(URI uri, File schematron) {
        return uri.getLastModified().getTime() + (long)this.schematronHash(schematron);
    }

    private Validator getValidator(File schematron) throws SchematronException {
        String key = schematron.getAbsolutePath() + "-" + this.schematronHash(schematron);
        Validator validator = this.validators.get(key);
        if (validator == null) {
            this.validators.entrySet().removeIf(existing -> ((String)existing.getKey()).startsWith(schematron.getAbsolutePath() + "-"));
            validator = Schematron.newValidator((Source)new StreamSource(schematron));
            this.validators.put(key, validator);
        }
        return validator;
    }

    private int schematronHash(File schematron) {
        ArrayList<Long> modifieds = new ArrayList<Long>();
        modifieds.add(schematron.lastModified());
        try {
            String content = Files.readString(schematron.toPath());
            Matcher matcher = INCLUDES.matcher(content);
            while (matcher.find()) {
                String path = matcher.group(1);
                File file = new File(schematron.getParent(), path);
                modifieds.add(file.lastModified());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to read schematron: " + schematron.getName(), (Throwable)ex);
        }
        return Arrays.hashCode(modifieds.toArray());
    }
}

