/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.member.SelfMember;
import com.pageseeder.publication.ListPublicationsForURI;
import com.pageseeder.search.Search;
import com.pageseeder.uri.FetchExternalURIMetadata;
import com.pageseeder.uri.FetchURLMetadata;
import com.pageseeder.uri.GetURIWorkflow;
import com.pageseeder.validation.ValidatorGeneratorRequest;
import com.pageseeder.validation.ValidatorGeneratorResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchematronURIResolver
implements URIResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronURIResolver.class);
    private static final int RESPONSE_CACHE_SIZE = 30;
    private final Group _group;
    private final URI _uri;
    private final Member _member;
    private final Database _db;
    private String _server = null;
    private boolean _urlMetadataRequested = false;
    private UserDetails userdetails = null;
    private @Nullable Map<String, String> _responseCache = null;

    public SchematronURIResolver(Group group, URI uri, Member member, Database db) {
        if (group == null || uri == null || member == null || db == null) {
            throw new NullPointerException();
        }
        this._group = group;
        this._uri = uri;
        this._member = member;
        this._db = db;
    }

    boolean wasUsed() {
        return this.userdetails != null;
    }

    boolean urlMetadataRequested() {
        return this._urlMetadataRequested;
    }

    void setResponseCache(Map<String, String> cache) {
        this._responseCache = cache;
    }

    public void setServerFromURI(URI uri) {
        Host host = uri.getHost();
        StringBuilder baseurl = new StringBuilder();
        baseurl.append(uri.getScheme()).append(':');
        if (!"mailto".equals(uri.getScheme())) {
            baseurl.append("//");
        }
        if (host != null) {
            baseurl.append(host.getName());
        }
        if (uri.getPort() != null && Rules.getDefaultPort((String)uri.getScheme()) != uri.getPort()) {
            baseurl.append(':').append(uri.getPort());
        }
        this._server = baseurl.toString();
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Group group;
        URI uri;
        LOGGER.debug("Resolving ({},{})", (Object)href, (Object)base);
        this.lazyInit();
        if (href.startsWith("ps:publications")) {
            return this.resolvePublications(href);
        }
        if (href.startsWith("ps:resource")) {
            return this.resolveResource(href);
        }
        if (href.startsWith("ps:search")) {
            return this.resolveSearch(href);
        }
        if (href.startsWith("ps:self")) {
            return this.resolveSelf(href);
        }
        if (href.startsWith("ps:source-metadata")) {
            return this.resolveSourceMetadata(href);
        }
        if (href.startsWith("ps:workflow")) {
            return this.resolveWorkflow(href);
        }
        URL url = this.buildURL(href, base);
        if (url != null && (uri = SchematronURIResolver.fetchURI(this._db, url)) != null && (group = SchematronURIResolver.identifyGroup(this._db, uri, this.userdetails)) != null) {
            return this.resolveDocument(uri, group);
        }
        StreamSource source = new StreamSource(new StringReader("<not-found/>"));
        source.setSystemId(href);
        return source;
    }

    private void lazyInit() {
        if (this.userdetails == null) {
            this.userdetails = new UserDetailsManager().get(this._db, this._member.getId(), false);
        }
    }

    private URL buildURL(String href, String base) {
        try {
            int question = href.indexOf(63);
            if (question != -1) {
                href = href.substring(0, question);
            }
            if (href.startsWith("file://")) {
                return null;
            }
            if (href.startsWith("http://") || href.startsWith("https://")) {
                return new URL(href);
            }
            if (href.startsWith("/") && this._server != null) {
                return new URL(this._server + href);
            }
            int slash = base.indexOf(47);
            if (slash != -1) {
                return new URL(base.substring(0, base.lastIndexOf(47) + 1) + href);
            }
            return new URL(base + href);
        }
        catch (MalformedURLException ex) {
            LOGGER.debug("Unable to construct URL to resolve due to", (Throwable)ex);
            return null;
        }
    }

    private static URI fetchURI(Database db, URL url) throws TransformerException {
        try {
            return URIRule.getURIByURL((Database)db, (URL)url);
        }
        catch (DatabaseException ex) {
            throw new TransformerException("Unable fetch URI for Schematron from " + String.valueOf(url), ex);
        }
    }

    private static Group identifyGroup(Database db, URI uri, UserDetails details) throws TransformerException {
        Group group;
        try {
            group = URIRule.getDefaultGroupForURI((URI)uri);
            if (group == null || !GroupRule.userHasAccess((Group)group, (UserDetails)details)) {
                group = URIRule.getGroupForURI((Database)db, (Long)uri.getId(), (UserDetails)details);
            }
        }
        catch (DatabaseException ex) {
            throw new TransformerException("Unable to load group for URI: " + ex.getMessage());
        }
        return group;
    }

    private Source resolveDocument(URI uri, Group group) throws TransformerException {
        try {
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setPSMLFormat(true);
            StreamSource source = new StreamSource(resolver.getContent(this._db));
            source.setSystemId(URIRule.getURIString((URI)uri));
            return source;
        }
        catch (URIException ex) {
            throw new TransformerException("Unable to resolve document " + String.valueOf(uri), ex);
        }
    }

    private Source resolveResource(String href) throws TransformerException {
        String error = null;
        Map<String, String> params = SchematronURIResolver.getParameters(href);
        String location = params.get("location");
        try {
            if (location != null && location.contains("..")) {
                error = "Resource location parameter is invalid: " + location;
            }
            if (error == null && !PermissionManager.check((Long)this._member.getId(), (UserDetails)this.userdetails, (Database)this._db, (Permissions)new Permissions(), (PermissionCheck)new ConfigureProjectCheck(this._group))) {
                error = "Access denied for resource: " + location;
            }
            String template = this._group.getOwnerDirectory();
            String path = "/WEB-INF/config/template/" + template + "/" + location;
            File file = Files.descendantFile((File)new File(Settings.getContextPath()), (String)path);
            String type = Medias.getMediaType((File)file);
            if (error == null && !Medias.isText((String)type)) {
                error = "Resource is not a text file: " + location;
            }
            if (error == null && file.exists() && file.isFile()) {
                return new StreamSource(new FileInputStream(file));
            }
            if (error == null) {
                StreamSource source = new StreamSource(new StringReader("<not-found/>"));
                source.setSystemId(href);
                return source;
            }
        }
        catch (Exception ex) {
            error = "Unable to resolve resource: " + location + ": " + ex.getMessage();
        }
        LOGGER.error(error);
        throw new TransformerException(error);
    }

    private Source resolveSearch(String href) throws TransformerException {
        StreamSource source;
        try {
            String result = this.getCache(href);
            if (result == null) {
                Group group = this._group;
                Map<String, String> params = SchematronURIResolver.getParameters(href);
                if (params.containsKey("project")) {
                    String project = params.get("project");
                    group = DatabaseQuery.getGroupByName((Database)this._db, (String)project);
                    if (group == null || !GroupRule.userHasAccess((Group)group, (UserDetails)this.userdetails) || !GroupRule.isProject((Group)group)) {
                        throw new TransformerException("Access denied for project " + project);
                    }
                    params.remove("project");
                }
                params.put("type", "question");
                ValidatorGeneratorRequest req = new ValidatorGeneratorRequest(this._member);
                req.setDatabase(this._db);
                req.setGroup(group);
                req.setMember(this._member);
                req.putParameters(params);
                StringWriter writer = new StringWriter();
                UniversalPrinter uni = UniversalPrinter.newWriter((Writer)writer, (OutputType)OutputType.XML);
                ValidatorGeneratorResponse res = new ValidatorGeneratorResponse(uni);
                new Search().process((GeneratorRequest)req, (GeneratorResponse)res);
                result = ((Object)writer).toString();
                this.putCache(href, result);
                if (res.getStatus() != GeneratorStatus.OK) {
                    String error = "Error " + String.valueOf(res.getErrorID() != null ? Integer.valueOf(res.getErrorID().id()) : "") + " " + res.getMessage() + " resolving: " + href;
                    LOGGER.error(error);
                    throw new TransformerException(error);
                }
            }
            source = new StreamSource(new StringReader(result));
        }
        catch (Exception ex) {
            throw new TransformerException(ex.getMessage(), ex);
        }
        return source;
    }

    private Source resolveSourceMetadata(String href) throws TransformerException {
        StreamSource source;
        try {
            Map<String, String> params = SchematronURIResolver.getParameters(href);
            ValidatorGeneratorRequest req = new ValidatorGeneratorRequest(this._member);
            req.setDatabase(this._db);
            req.putParameters(params);
            StringWriter writer = new StringWriter();
            UniversalPrinter uni = UniversalPrinter.newWriter((Writer)writer, (OutputType)OutputType.XML);
            ValidatorGeneratorResponse res = new ValidatorGeneratorResponse(uni);
            if (!params.containsKey("url")) {
                req.setURI(this._uri);
                params.put("reload", "true");
                this._urlMetadataRequested = true;
                new FetchExternalURIMetadata().process((GeneratorRequest)req, (GeneratorResponse)res);
            } else {
                new FetchURLMetadata().process((GeneratorRequest)req, (GeneratorResponse)res);
            }
            if (res.getStatus() != GeneratorStatus.OK) {
                String error = "Error " + String.valueOf(res.getErrorID() != null ? Integer.valueOf(res.getErrorID().id()) : "") + " " + res.getMessage() + " resolving: " + href;
                LOGGER.error(error);
                throw new TransformerException(error);
            }
            source = new StreamSource(new StringReader(((Object)writer).toString()));
        }
        catch (Exception ex) {
            throw new TransformerException(ex.getMessage(), ex);
        }
        return source;
    }

    private Source resolveSelf(String href) throws TransformerException {
        StreamSource source;
        try {
            String result = this.getCache(href);
            if (result == null) {
                ValidatorGeneratorRequest req = new ValidatorGeneratorRequest(this._member);
                req.setDatabase(this._db);
                StringWriter writer = new StringWriter();
                UniversalPrinter uni = UniversalPrinter.newWriter((Writer)writer, (OutputType)OutputType.XML);
                ValidatorGeneratorResponse res = new ValidatorGeneratorResponse(uni);
                new SelfMember().process((GeneratorRequest)req, (GeneratorResponse)res);
                result = ((Object)writer).toString();
                this.putCache(href, result);
                if (res.getStatus() != GeneratorStatus.OK) {
                    String error = "Error " + String.valueOf(res.getErrorID() != null ? Integer.valueOf(res.getErrorID().id()) : "") + " " + res.getMessage() + " resolving: " + href;
                    LOGGER.error(error);
                    throw new TransformerException(error);
                }
            }
            source = new StreamSource(new StringReader(result));
        }
        catch (Exception ex) {
            throw new TransformerException(ex.getMessage(), ex);
        }
        return source;
    }

    private Source resolveWorkflow(String href) throws TransformerException {
        StreamSource source;
        try {
            ValidatorGeneratorRequest req = new ValidatorGeneratorRequest(this._member);
            req.setDatabase(this._db);
            req.setGroup(this._group);
            req.setURI(this._uri);
            StringWriter writer = new StringWriter();
            UniversalPrinter uni = UniversalPrinter.newWriter((Writer)writer, (OutputType)OutputType.XML);
            ValidatorGeneratorResponse res = new ValidatorGeneratorResponse(uni);
            new GetURIWorkflow().process((GeneratorRequest)req, (GeneratorResponse)res);
            if (res.getStatus() != GeneratorStatus.OK) {
                String error = "Error " + String.valueOf(res.getErrorID() != null ? Integer.valueOf(res.getErrorID().id()) : "") + " " + res.getMessage() + " resolving: " + href;
                LOGGER.error(error);
                throw new TransformerException(error);
            }
            source = new StreamSource(new StringReader(((Object)writer).toString()));
        }
        catch (Exception ex) {
            throw new TransformerException(ex.getMessage(), ex);
        }
        return source;
    }

    private Source resolvePublications(String href) throws TransformerException {
        StreamSource source;
        try {
            ValidatorGeneratorRequest req = new ValidatorGeneratorRequest(this._member);
            req.setDatabase(this._db);
            req.setGroup(this._group);
            req.setURI(this._uri);
            req.setMember(this._member);
            StringWriter writer = new StringWriter();
            UniversalPrinter uni = UniversalPrinter.newWriter((Writer)writer, (OutputType)OutputType.XML);
            ValidatorGeneratorResponse res = new ValidatorGeneratorResponse(uni);
            new ListPublicationsForURI().process((GeneratorRequest)req, (GeneratorResponse)res);
            if (res.getStatus() != GeneratorStatus.OK) {
                String error = "Error " + String.valueOf(res.getErrorID() != null ? Integer.valueOf(res.getErrorID().id()) : "") + " " + res.getMessage() + " resolving: " + href;
                LOGGER.error(error);
                throw new TransformerException(error);
            }
            source = new StreamSource(new StringReader(((Object)writer).toString()));
        }
        catch (Exception ex) {
            throw new TransformerException(ex.getMessage(), ex);
        }
        return source;
    }

    private static Map<String, String> getParameters(String href) {
        int q = href.indexOf(63);
        String query = q == -1 ? "" : href.substring(q + 1);
        ArrayList<String> pl = new ArrayList<String>(Arrays.asList(query.split("&")));
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : pl) {
            int i = param.indexOf(61);
            if (i == -1) continue;
            String name = param.substring(0, i);
            String value = param.substring(i + 1);
            params.put(URLDecoder.decode(name, StandardCharsets.UTF_8), URLDecoder.decode(value, StandardCharsets.UTF_8));
        }
        return params;
    }

    private @Nullable String getCache(String href) {
        if (this._responseCache == null) {
            return null;
        }
        return this._responseCache.get(href);
    }

    private void putCache(String href, String content) {
        if (this._responseCache == null || this._responseCache.size() >= 30) {
            return;
        }
        LOGGER.debug("Caching URI response for: " + href);
        this._responseCache.put(href, content);
    }
}

