/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

public class Range {
    private final long _start;
    private final long _end;

    public Range(long start, long end) {
        if (start > end || start < 0L) {
            throw new IllegalArgumentException();
        }
        this._start = start;
        this._end = end;
    }

    public static Range fromString(String range, long total) throws IllegalArgumentException {
        int i = range.indexOf(45);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        String first = range.substring(0, i);
        String second = range.substring(i + 1, range.length());
        try {
            if (first.isEmpty()) {
                long start = total - Long.parseLong(second);
                if (start < 0L) {
                    start = 0L;
                }
                return new Range(start, total - 1L);
            }
            if (second.isEmpty()) {
                return new Range(Long.parseLong(first), total - 1L);
            }
            long end = Long.parseLong(second);
            if (end > total - 1L) {
                end = total - 1L;
            }
            return new Range(Long.parseLong(first), end);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException();
        }
    }

    public long start() {
        return this._start;
    }

    public long end() {
        return this._end;
    }

    public long length() {
        return this._end - this._start + 1L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        return this._start == ((Range)o).start() && this._end == ((Range)o).end();
    }

    public String toString() {
        return this._start + "-" + this._end;
    }
}

