/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

public final class MatchOptions {
    private static final MatchOptions EXACT = new MatchOptions(true, true, false);
    private final boolean literal;
    private final boolean caseSensitive;
    private final boolean word;

    private MatchOptions(boolean literal, boolean caseSensitive, boolean word) {
        this.literal = literal;
        this.caseSensitive = caseSensitive;
        this.word = word;
    }

    public static MatchOptions exactMatch() {
        return EXACT;
    }

    public static MatchOptions regex() {
        return new MatchOptions(false, true, false);
    }

    public MatchOptions literal(boolean literal) {
        if (this.literal == literal) {
            return this;
        }
        return new MatchOptions(literal, this.caseSensitive, this.word);
    }

    public MatchOptions caseSensitive(boolean caseSensitive) {
        if (this.caseSensitive == caseSensitive) {
            return this;
        }
        return new MatchOptions(this.literal, caseSensitive, this.word);
    }

    public MatchOptions word(boolean word) {
        if (this.word == word) {
            return this;
        }
        return new MatchOptions(this.literal, this.caseSensitive, word);
    }

    public boolean isExactMatch() {
        return this.equals(EXACT);
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isWord() {
        return this.word;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchOptions that = (MatchOptions)o;
        if (this.literal != that.literal) {
            return false;
        }
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        return this.word == that.word;
    }

    public int hashCode() {
        int result = this.literal ? 1 : 0;
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        result = 31 * result + (this.word ? 1 : 0);
        return result;
    }
}

