/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import org.pageseeder.xmlwriter.esc.XMLEscapeUTF8;

public final class ExtractBuilder {
    private final StringBuilder extract = new StringBuilder();
    private final int maxLength;
    private int length = 0;

    ExtractBuilder(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public ExtractBuilder text(String text) {
        if (this.length >= this.maxLength) {
            return this;
        }
        return this.length == 0 ? this.before(text) : this.after(text);
    }

    private ExtractBuilder before(String text) {
        int start = Math.max(0, text.length() - this.maxLength / 2);
        if (start > 0) {
            return this.ellipsis().append(text.substring(start));
        }
        return this.append(text);
    }

    private ExtractBuilder after(String text) {
        int allowed = this.maxLength - this.length;
        if (text.length() > allowed) {
            return this.append(text.substring(0, allowed)).ellipsis();
        }
        return this.append(text);
    }

    public ExtractBuilder append(String text) {
        this.extract.append(XMLEscapeUTF8.UTF8_ESCAPE.toElementText(text.replaceAll("\n", "")));
        this.length += text.length();
        return this;
    }

    public ExtractBuilder ellipsis() {
        this.extract.append('\u2026');
        return this;
    }

    public ExtractBuilder mark(String term) {
        if (this.length >= this.maxLength) {
            return this;
        }
        this.extract.append("<mark>");
        this.extract.append(XMLEscapeUTF8.UTF8_ESCAPE.toElementText(term));
        this.extract.append("</mark>");
        this.length += term.length();
        return this;
    }

    public int length() {
        return this.length;
    }

    public String toString() {
        return this.extract.toString();
    }
}

