/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.utils.FilenameTransform;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DynamicStrings {
    private DynamicStrings() {
    }

    public static String process(String src, Map<String, String> parameters, int number, Date date) throws ParseException {
        DynamicString ds = DynamicString.parse(src, null, false);
        return ds.process(parameters, number, date);
    }

    public static String toSQLLike(String src, int number, String transform, boolean path) throws ParseException {
        String tf;
        boolean hasTrim = transform != null && transform.contains("trim");
        String string = tf = hasTrim ? transform.replaceFirst("(,trim)|(trim,)|(^trim$)", "") : transform;
        if (path) {
            StringBuilder transformed = new StringBuilder();
            String[] elements = src.split("((?<=/)|(?=/))");
            boolean ignoreNextIfSlash = false;
            for (String element : elements) {
                if ("/".equals(element)) {
                    if (!ignoreNextIfSlash) {
                        transformed.append('/');
                    }
                    ignoreNextIfSlash = true;
                    continue;
                }
                String source = hasTrim ? FilenameTransform.transformPath(element, "trim") : element;
                DynamicString ds = DynamicString.parse(source, tf, path);
                transformed.append(ds.toSQLLike(number));
                ignoreNextIfSlash = false;
            }
            return transformed.toString();
        }
        String source = hasTrim ? FilenameTransform.transformPath(src, "trim") : src;
        DynamicString ds = DynamicString.parse(source, tf, path);
        return ds.toSQLLike(number);
    }

    public static String explain(String src) throws ParseException {
        DynamicString ds = DynamicString.parse(src, null, false);
        return ds.explain();
    }

    private static class NumberPart
    implements Part {
        private final char _symbol;
        private final int _digits;
        private final boolean _overflow;
        private final int _argument;

        public NumberPart(char symbol, int digits, boolean overflow, int argument) {
            this._symbol = symbol;
            this._digits = digits;
            this._overflow = overflow;
            this._argument = argument;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            int value = this.getValue(number, date);
            String format = this.format(value);
            out.append(format);
        }

        @Override
        public void sqlLike(StringBuilder out, int number, String transform, boolean path) {
            if (this._symbol == 'N' || this._symbol == 'P' || this._symbol == 'Q' || this._symbol == 'K') {
                out.append(this.format(this.getValue(number, null)));
            } else {
                out.append('%');
            }
        }

        public int getValue(int number, Date date) {
            switch (this._symbol) {
                case 'N': {
                    return number;
                }
                case 'P': {
                    return number / this._argument;
                }
                case 'Q': {
                    return number / this._argument + 1;
                }
                case 'K': {
                    return number / 1000;
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            switch (this._symbol) {
                case 'Y': {
                    return calendar.get(1);
                }
                case 'M': {
                    return calendar.get(2) + 1;
                }
                case 'D': {
                    return calendar.get(5);
                }
                case 'W': {
                    return calendar.get(3);
                }
            }
            return 0;
        }

        public String format(int value) {
            String format = Integer.toString(value);
            if (this._digits > 1) {
                int diff = this._digits - format.length();
                if (diff > 0) {
                    StringBuilder padded = new StringBuilder();
                    for (int i = 0; i < diff; ++i) {
                        padded.append('0');
                    }
                    padded.append(format);
                    format = padded.toString();
                } else if (diff < 0 && !this._overflow) {
                    format = format.substring(format.length() - this._digits, format.length());
                }
            }
            return format;
        }

        @Override
        public void explain(StringBuilder out) {
            out.append('[');
            switch (this._symbol) {
                case 'N': {
                    out.append("autonumber");
                    break;
                }
                case 'P': {
                    out.append("autonumber div ").append(this._argument);
                    break;
                }
                case 'Q': {
                    out.append("autonumber div ").append(this._argument).append(" + 1");
                    break;
                }
                case 'K': {
                    out.append("autonumber div 1000");
                    break;
                }
                case 'Y': {
                    out.append("year");
                    break;
                }
                case 'M': {
                    out.append("month");
                    break;
                }
                case 'D': {
                    out.append("day of year");
                    break;
                }
                case 'W': {
                    out.append("week of year");
                }
            }
            if (this._digits > 1) {
                out.append(this._overflow ? ", min " : ", last ");
                out.append(this._digits).append(" digits");
            }
            out.append(']');
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('{');
            for (int i = 0; i < this._digits - 1; ++i) {
                out.append(this._overflow ? (char)'0' : (char)this._symbol);
            }
            out.append(this._symbol);
            if (this._argument > 0) {
                out.append(this._argument);
            }
            out.append('}');
            return out.toString();
        }

        public static NumberPart parse(String part) throws ParseException {
            Pattern p = Pattern.compile("(0*)([NPQKYMDW]+)(\\d*)");
            Matcher m = p.matcher(part);
            boolean matches = m.matches();
            if (matches) {
                char symbol = m.group(2).charAt(0);
                int digits = m.group(1).length() + m.group(2).length();
                boolean overflow = digits <= 1 || m.group(1).length() > 0;
                int argument = m.group(3).length() > 0 ? Integer.parseInt(m.group(3)) : 0;
                return new NumberPart(symbol, digits, overflow, argument);
            }
            throw new ParseException("Not a valid dynamic element", 0);
        }
    }

    private static class ParameterPart
    implements Part {
        private final String _name;

        private ParameterPart(String name) {
            this._name = name;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            String value = parameters.get(this._name);
            if (value != null) {
                out.append(value);
            }
        }

        @Override
        public void sqlLike(StringBuilder out, int number, String transform, boolean path) {
            out.append('%');
        }

        public static ParameterPart parse(String part) throws ParseException {
            if (part.length() < 2) {
                throw new ParseException("Invalid dynamic parameter {" + part + "}", 0);
            }
            return new ParameterPart(part.substring(1));
        }

        @Override
        public void explain(StringBuilder out) {
            out.append("[valueof=").append(this._name).append("]");
        }

        public String toString() {
            return "{$" + this._name + "}";
        }
    }

    private static class StaticPart
    implements Part {
        private final String _s;

        public StaticPart(String s) {
            this._s = s;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            out.append(this._s);
        }

        @Override
        public void explain(StringBuilder out) {
            out.append('\"').append(this._s).append('\"');
        }

        @Override
        public void sqlLike(StringBuilder out, int number, String transform, boolean path) {
            if (transform != null && path) {
                out.append(FilenameTransform.transformPath(this._s, transform));
            } else if (transform != null) {
                out.append(FilenameTransform.transform(this._s, transform));
            } else {
                out.append(this._s);
            }
        }

        public String toString() {
            return this._s;
        }
    }

    private static interface Part {
        public void write(StringBuilder var1, Map<String, String> var2, int var3, Date var4);

        public void explain(StringBuilder var1);

        public void sqlLike(StringBuilder var1, int var2, String var3, boolean var4);
    }

    private static final class DynamicString {
        private final String _transform;
        private final boolean _path;
        private final List<Part> _parts;

        private DynamicString(List<Part> parts, String transform, boolean path) {
            this._parts = parts;
            this._transform = transform;
            this._path = path;
        }

        public static DynamicString parse(String src, String transform, boolean path) throws ParseException {
            ArrayList<Part> parts = new ArrayList<Part>();
            Pattern p = Pattern.compile("\\{([^}}]+)\\}");
            Matcher m = p.matcher(src);
            int end = 0;
            while (m.find(end)) {
                if (m.start() > end) {
                    parts.add(new StaticPart(src.substring(end, m.start())));
                }
                try {
                    String dynamic = m.group(1);
                    if (dynamic.charAt(0) == '$') {
                        parts.add(ParameterPart.parse(dynamic));
                    } else {
                        parts.add(NumberPart.parse(dynamic));
                    }
                }
                catch (ParseException ex) {
                    throw new ParseException(ex.getMessage(), m.start() + 1 + ex.getErrorOffset());
                }
                end = m.end();
            }
            if (end < src.length()) {
                parts.add(new StaticPart(src.substring(end, src.length())));
            }
            return new DynamicString(parts, transform, path);
        }

        public String process(Map<String, String> parameters, int number, Date date) {
            StringBuilder out = new StringBuilder();
            for (Part p : this._parts) {
                p.write(out, parameters, number, date);
            }
            return out.toString();
        }

        public String toSQLLike(int number) {
            StringBuilder out = new StringBuilder();
            for (Part p : this._parts) {
                p.sqlLike(out, number, this._transform, this._path);
            }
            return out.toString();
        }

        public String explain() {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < this._parts.size(); ++i) {
                if (i > 0) {
                    out.append(" + ");
                }
                this._parts.get(i).explain(out);
            }
            return out.toString();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            for (Part p : this._parts) {
                out.append(p.toString());
            }
            return out.toString();
        }
    }
}

