/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.display.WebImage;
import com.pageseeder.url.FaviconImage;
import com.pageseeder.url.URLMetadata;
import com.pageseeder.url.URLMetadataExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFaviconServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalFaviconServlet.class);
    private static final String URL_SVG_PATH = "M 256.315 0 C 399.625 0 512 113.637 512 255.053 C 512 397.731 399.625 511.368 256.315 511.368 C 114.269 511.368 0 397.731 0 255.053 C 0 113.637 114.269 0 256.315 0 Z M 270.836 463.387 C 311.872 463.387 333.969 392.049 344.068 356.696 C 319.447 359.221 295.457 360.483 270.836 361.115 L 270.836 463.387 Z M 189.396 411.619 C 201.39 440.03 219.699 463.387 240.532 463.387 L 240.532 361.115 C 216.543 360.483 191.921 359.221 167.931 356.696 C 172.981 376.898 179.926 395.206 189.396 411.619 Z M 49.243 284.094 C 59.343 296.088 85.228 311.872 132.577 320.079 C 129.42 300.507 128.159 278.412 128.159 256.947 C 128.159 241.164 128.788 228.537 130.051 214.018 C 94.067 206.442 72.602 201.39 56.187 193.815 C 50.506 212.755 47.349 234.22 47.349 255.053 C 47.349 265.154 47.349 275.255 49.243 284.094 Z M 156.567 256.947 C 156.567 280.306 157.829 304.296 160.986 325.761 C 188.134 330.812 214.018 332.705 240.532 333.969 L 240.532 222.223 C 212.123 221.593 183.713 220.331 157.199 217.174 C 157.199 231.063 156.567 243.058 156.567 256.947 Z M 239.27 47.981 C 203.915 62.5 173.613 117.426 160.986 190.027 C 186.87 192.553 214.018 193.815 240.532 195.078 L 240.532 47.981 L 239.27 47.981 Z M 291.039 59.343 C 284.094 54.294 276.517 47.981 270.836 47.981 L 270.836 195.078 C 298.614 193.815 324.498 192.553 351.014 190.027 C 340.912 133.208 318.184 83.334 291.039 59.343 Z M 270.836 333.969 C 298.614 332.705 324.498 330.812 350.382 326.392 C 354.169 305.558 355.433 280.937 355.433 256.947 C 355.433 243.058 355.433 231.063 354.169 217.805 C 327.655 220.331 299.877 221.593 270.836 222.223 L 270.836 333.969 Z M 381.948 214.018 C 383.842 228.537 383.842 241.164 383.842 256.947 C 383.842 278.412 381.948 301.139 379.423 321.341 C 461.494 307.453 464.651 288.513 464.651 255.053 C 464.651 234.85 461.494 214.018 455.181 195.078 C 440.66 201.39 413.514 210.861 381.948 214.018 Z M 444.449 167.3 C 422.352 118.056 380.685 78.916 331.442 61.237 C 355.433 92.173 369.952 135.734 378.16 186.87 C 420.458 179.294 438.135 171.719 444.449 167.3 Z M 109.218 108.586 C 90.91 125.633 77.652 145.835 68.183 166.669 C 75.127 172.981 87.121 173.613 133.208 186.239 C 142.047 135.734 157.199 94.067 180.556 62.5 C 154.042 75.127 130.051 85.859 109.218 108.586 Z M 109.218 402.15 C 128.159 422.984 151.516 436.873 176.137 447.606 C 157.829 422.352 145.835 389.524 138.259 351.645 C 106.693 344.7 78.284 335.861 59.343 325.761 C 71.34 354.801 85.859 381.317 109.218 402.15 Z M 403.412 402.15 C 425.509 381.948 440.66 356.696 450.763 328.917 C 429.928 338.387 403.412 346.593 374.372 352.907 C 365.533 390.787 354.169 421.09 335.231 447.606 C 359.852 436.873 384.473 422.984 403.412 402.15 Z";
    private static final String URL_SLASH_SVG_PATH = "M 256.3 0 C 311.2 0 361.5 16.7 402.7 45.2 L 368.5 79.4 C 356.8 72 344.4 65.9 331.4 61.2 C 339.3 71.4 346.2 83 352.2 95.7 L 329.9 118 C 319.1 92.8 305.7 72.3 291 59.3 C 284.1 54.3 276.5 48 270.8 48 L 270.8 177.1 L 226 221.8 C 202.5 221.1 179.2 219.8 157.2 217.2 C 157.2 231.1 156.6 243.1 156.6 256.9 C 156.6 268 156.9 279.3 157.5 290.3 L 131.9 315.9 C 129.2 297.4 128.2 276.9 128.2 256.9 C 128.2 241.2 128.8 228.5 130.1 214 C 94.1 206.4 72.6 201.4 56.2 193.8 C 50.5 212.8 47.3 234.2 47.3 255.1 C 47.3 265.2 47.3 275.3 49.2 284.1 C 59 295.7 83.7 311 128.5 319.4 L 104.7 343.1 C 86.9 338 71.2 332.1 59.3 325.8 C 65.4 340.5 72.1 354.5 80.3 367.5 L 45.8 402 C 16.9 360.5 0 310 0 255.1 C 0 113.6 114.3 0 256.3 0 Z M 512 255.1 C 512 397.7 399.6 511.4 256.3 511.4 C 201.8 511.4 151.3 494.6 109.9 465.9 L 144.6 431.3 C 154.6 437.5 165.2 442.9 176.1 447.6 C 169.5 438.5 163.6 428.3 158.6 417.2 L 180.9 394.9 C 183.5 400.7 186.3 406.2 189.4 411.6 C 201.4 440 219.7 463.4 240.5 463.4 L 240.5 361.1 C 232.3 360.9 224 360.6 215.6 360.2 L 270.8 305 L 270.8 334 C 298.6 332.7 324.5 330.8 350.4 326.4 C 354.2 305.6 355.4 280.9 355.4 256.9 C 355.4 244.3 355.4 233.3 354.5 221.4 L 391.5 184.3 C 424.3 177.6 438.8 171.2 444.4 167.3 C 440.8 159.2 436.6 151.4 432 143.9 L 466.8 109.1 C 495.4 150.4 512 200.7 512 255.1 Z M 270.8 463.4 C 311.9 463.4 334 392 344.1 356.7 C 319.4 359.2 295.5 360.5 270.8 361.1 Z M 239.3 48 C 203.9 62.5 173.6 117.4 161 190 C 186.9 192.6 214 193.8 240.5 195.1 L 240.5 48 Z M 381.9 214 C 383.8 228.5 383.8 241.2 383.8 256.9 C 383.8 278.4 381.9 301.1 379.4 321.3 C 461.5 307.5 464.7 288.5 464.7 255.1 C 464.7 234.9 461.5 214 455.2 195.1 C 440.7 201.4 413.5 210.9 381.9 214 Z M 109.2 108.6 C 90.9 125.6 77.7 145.8 68.2 166.7 C 75.1 173 87.1 173.6 133.2 186.2 C 142 135.7 157.2 94.1 180.6 62.5 C 154 75.1 130.1 85.9 109.2 108.6 Z M 403.4 402.2 C 425.5 381.9 440.7 356.7 450.8 328.9 C 429.9 338.4 403.4 346.6 374.4 352.9 C 365.5 390.8 354.2 421.1 335.2 447.6 C 359.9 436.9 384.5 423 403.4 402.2 Z M 454.4 34.6 L 477.1 57.2 C 480.2 60.3 480.2 65.4 477.1 68.5 L 68.3 477.3 C 65.2 480.4 60.1 480.4 57 477.3 L 34.3 454.7 C 31.2 451.6 31.2 446.5 34.3 443.4 L 443.1 34.6 C 446.2 31.5 451.3 31.5 454.4 34.6 Z";
    private static final long serialVersionUID = 20231201L;
    private static SafeCacheWrapper<String, FaviconImage> cache = SafeCacheWrapper.getInstance((String)"external-favicons");

    public String getServletInfo() {
        return "Handles member profile picture.";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String hostname;
        URL origin;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((origin = this.toHttpsOrigin(hostname = req.getParameter(StandardParameters.hostname.getName()))) == null) {
            this.writeFallbackNoCache(res, true);
            return;
        }
        long start = System.currentTimeMillis();
        FaviconImage image = (FaviconImage)cache.get((Serializable)((Object)origin.getHost()));
        if (image != null && !"no-cache".equals(req.getHeader("Cache-Control"))) {
            res.setHeader("Server-Timing", "cache;desc=hit;dur=" + (System.currentTimeMillis() - start));
            image.write(req, res);
            return;
        }
        this.getFavicon(req, res, hostname, image);
    }

    public void getFavicon(HttpServletRequest req, HttpServletResponse res, String host, @Nullable FaviconImage cachedImage) throws IOException {
        Object iconUrl;
        String scheme = "https";
        URLMetadata metadata = URLMetadataExtractor.extractNoHostCheck(scheme + "://" + host);
        if (metadata.isUnresolved()) {
            scheme = "http";
            LOGGER.debug("Downgrading to http for {}", (Object)host);
            metadata = URLMetadataExtractor.extractNoHostCheck(scheme + "://" + host);
            if (metadata.isUnresolved()) {
                LOGGER.debug("Unable to connect to {}", (Object)host);
                this.writeFallback(res, true, host);
                return;
            }
        }
        if (((String)(iconUrl = metadata.getIconURL())).isEmpty()) {
            iconUrl = scheme + "://" + host + "/favicon.ico";
        }
        try {
            this.fetchIcon(req, res, new URL((String)iconUrl), host, cachedImage);
        }
        catch (Exception ex) {
            this.writeFallbackNoCache(res, false);
        }
    }

    void fetchIcon(HttpServletRequest req, HttpServletResponse res, URL iconUrl, String host, @Nullable FaviconImage cachedImage) throws IOException {
        block13: {
            try {
                HttpURLConnection connection = (HttpURLConnection)iconUrl.openConnection();
                ExternalFaviconServlet.setConnectionDefaults(connection, req);
                if (cachedImage != null) {
                    connection.addRequestProperty("If-Modified-Since", HttpRequests.toLastModified((long)cachedImage.getLastModified()));
                }
                connection.setRequestMethod("GET");
                int httpCode = connection.getResponseCode();
                String contentType = connection.getContentType();
                LOGGER.debug("Got icon {} - {}", (Object)iconUrl, (Object)httpCode);
                if (httpCode == 200 && contentType.startsWith("image/")) {
                    byte[] imageBytes;
                    try (InputStream in = connection.getInputStream();){
                        imageBytes = IOUtils.toByteArray((InputStream)in);
                    }
                    boolean gzip = "gzip".equals(connection.getHeaderField("Content-Encoding"));
                    long lastModified = connection.getLastModified();
                    OriginFavicon image = new OriginFavicon(iconUrl, imageBytes, contentType, lastModified, gzip);
                    this.addToCache(host, image, lastModified);
                    image.write(res);
                    break block13;
                }
                if (httpCode == 304 && cachedImage != null) {
                    cachedImage.write(res);
                } else {
                    this.writeFallback(res, false, host);
                }
            }
            catch (UnknownHostException ex) {
                this.writeFallback(res, true, host);
            }
        }
    }

    private void writeFallbackNoCache(HttpServletResponse res, boolean unreachable) throws IOException {
        this.writeFallback(res, unreachable, null);
    }

    private void writeFallback(HttpServletResponse res, boolean unreachable, String host) throws IOException {
        FallbackImage image = new FallbackImage(unreachable);
        if (host != null) {
            this.addToCache(host, image, 0L);
        }
        image.write(res);
    }

    private URL toHttpsOrigin(String hostname) {
        if (hostname == null || hostname.isEmpty()) {
            return null;
        }
        try {
            return new URL("https://" + hostname);
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Invalid hostname {}", (Object)hostname);
            return null;
        }
    }

    private static void setConnectionDefaults(HttpURLConnection connection, HttpServletRequest req) {
        connection.setInstanceFollowRedirects(true);
        connection.setDefaultUseCaches(false);
        connection.setConnectTimeout(20000);
        connection.addRequestProperty("Accept", "image/*");
        connection.addRequestProperty("Accept-Encoding", "gzip");
        String userAgent = req.getHeader("User-Agent");
        if (userAgent == null) {
            userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36";
        }
        connection.addRequestProperty("User-Agent", userAgent);
        connection.addRequestProperty("Referer", URLs.asString((String)Settings.getServerScheme(), (String)GlobalSettings.get((String)"webSiteAddress"), (int)Settings.getServerPort(), (String)"/"));
    }

    private void addToCache(String host, FaviconImage image, long lastModified) {
        Element element = new Element((Serializable)((Object)host), (Serializable)image, lastModified);
        element.setTimeToIdle(2592000);
        cache.putElement(element);
    }

    static class FallbackImage
    extends FaviconImage
    implements WebImage,
    Serializable {
        private static final long serialVersionUID = 20231201L;
        private final boolean unreachable;

        public FallbackImage(boolean unreachable) {
            super(System.currentTimeMillis(), "\"" + MD5.hash((String)(unreachable + Long.toString(System.currentTimeMillis()))).substring(0, 8) + "\"");
            this.unreachable = unreachable;
        }

        private String getPath() {
            return this.unreachable ? ExternalFaviconServlet.URL_SLASH_SVG_PATH : ExternalFaviconServlet.URL_SVG_PATH;
        }

        private String getColor() {
            return this.unreachable ? "#ffcc00" : "#bfe4ff";
        }

        @Override
        public void write(HttpServletResponse res) throws IOException {
            res.setContentType("image/svg+xml");
            res.setDateHeader("Last-Modified", this.getLastModified());
            this.writeCommonHeaders(res);
            PrintWriter w = res.getWriter();
            w.println("<?xml version=\"1.0\"?>");
            w.println("<svg version=\"1.0\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 512 512\" width=\"128\" height=\"128\">");
            w.println("<path d=\"" + this.getPath() + "\" fill=\"" + this.getColor() + "\" />");
            w.println("</svg>");
            w.flush();
        }
    }

    static class OriginFavicon
    extends FaviconImage
    implements WebImage,
    Serializable {
        private static final long serialVersionUID = 20231201L;
        private final byte[] content;
        private final String mediaType;
        private final String url;
        private final boolean gzip;

        public OriginFavicon(URL url, byte[] content, String mediaType, long lastModified, boolean gzip) {
            super(lastModified, "\"" + MD5.hash((byte[])content).substring(0, 8) + "\"");
            this.url = url.toString();
            this.content = content;
            this.mediaType = mediaType;
            this.gzip = gzip;
        }

        @Override
        public void write(HttpServletResponse res) throws IOException {
            if (this.gzip) {
                res.setHeader("Content-Encoding", "gzip");
            }
            res.setContentType(this.mediaType);
            res.setContentLength(this.content.length);
            res.setHeader("Link", "<" + this.url + ">; rel=\"self\"");
            res.setDateHeader("Last-Modified", this.getLastModified());
            this.writeCommonHeaders(res);
            ServletOutputStream out = res.getOutputStream();
            out.write(this.content);
            out.flush();
        }
    }
}

