/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.validation.SchematronValidationManager;
import com.pageseeder.validation.ValidationResults;
import com.pageseeder.validation.Validators;
import java.io.File;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, member=true, group=true, uri=true)
@PublicAPI
public final class ValidateURI
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        boolean defaultSchema;
        Group group = req.getGroup();
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Member member = req.getMember();
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("validation", true);
        xml.attribute("uriid", Long.toString(uri.getId()));
        String name = req.getParameter((Parameter)StandardParameters.schema);
        SchematronValidationManager validator = SchematronValidationManager.getInstance();
        ValidationResults results = null;
        boolean bl = defaultSchema = name == null || "default.sch".equals(name);
        if (defaultSchema) {
            results = validator.getValidationResults(group, uri, member, db, null);
            name = "default.sch";
        } else {
            File schema = Validators.findSchema(group, uri, name);
            if (schema != null) {
                name = schema.getName();
            }
            results = validator.validate(group, uri, schema, member, db, null);
        }
        if (name != null) {
            xml.attribute("schema", name);
        }
        if (results != null) {
            if (results.wasValidated()) {
                xml.attribute("status", results.isValid() ? "pass" : "fail");
                xml.writeXML(results.getSVRLResults());
            } else if (results.wasSchemaNotFound()) {
                xml.attribute("status", "not-found");
                xml.attribute("error", results.getErrorMessage());
            } else if (results.hasError()) {
                xml.attribute("status", "error");
                xml.attribute("error", results.getErrorMessage());
            }
        }
        xml.closeElement();
    }
}

