/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.MoveURIThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class UnarchiveURI
implements Generator,
SingleCheck {
    @ContentPermission(value=ArchiveURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        if (URIs.isExternal((URI)uri)) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ArchiveURICheck(uri, req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URI uri = req.getURI();
        Group grp = req.getGroup();
        Database db = req.getDatabase();
        boolean resolve = req.getParameter((Parameter)StandardParameters.resolve, false);
        String archivePath = GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', '/') + "/archive";
        boolean isFolder = URIRule.isFolder((URI)uri);
        if (!uri.getPath().startsWith(archivePath + "/")) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NOT_ARCHIVED);
            return;
        }
        String previousPath = this.getPreviousPath(db, uri, archivePath);
        if (previousPath == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.PREVIOUS_LOCATION_UNKNOWN, "The previous location is unknown. Drag the " + (isFolder ? "folder" : "document") + " out of the archive folder instead.");
            return;
        }
        URI folder = null;
        int i = previousPath.lastIndexOf(47);
        if (i != -1) {
            folder = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)previousPath.substring(0, i));
        }
        if (folder == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FOLDER_MISSING, "The folder for previous location " + previousPath + " is missing. Create it or drag the " + (isFolder ? "folder" : "document") + " out of the archive folder instead.");
            return;
        }
        if (!PermissionManager.check((HttpServletRequest)req.getHttpServletRequest(), (Database)db, (Permissions)new Permissions(), (PermissionCheck)new ViewURICheck(folder))) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FOLDER_INVALID, "You do not have edit access to the folder for previous location " + previousPath + " . Move the " + (isFolder ? "folder" : "document") + " out of the archive folder instead.");
            return;
        }
        Long uriid = uri.getId();
        MoveURIThread thread = MoveURIThread.newInstance(false, req.getMember().getUsername(), grp);
        thread.addURIToMove(uriid, null);
        thread.setCommentGroups(Collections.singletonList(grp.getName()));
        thread.setDestinationDetails(folder.getScheme(), folder.getHost().getName(), folder.getPort(), folder.getPath());
        thread.setResolveXRefs(resolve);
        if (isFolder) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("uri-unarchive");
            thread.print((OutputPrinter)out);
            out.endObject();
            out.flush();
        } else {
            ProcessManager manager = ProcessManager.getInstance();
            manager.prepareForStart((ProcessThread)thread, true);
            if (!thread.run(db, req.getTransaction())) {
                req.getTransaction().abort();
                res.setError(GeneratorStatus.BAD_REQUEST, thread.getCurrentStatus().getMessage());
            } else {
                UniversalPrinter out = res.getUniversalWriter();
                out.startObject("uri-unarchive");
                out.field("threadid", thread.getThreadID());
                if (thread.hasWarning()) {
                    out.field("warning", true);
                }
                out.writeURI(DatabaseQuery.getURIById((Database)db, (Long)uriid));
                out.endObject();
                out.flush();
            }
            manager.clearIfFinished(thread.getThreadID());
        }
    }

    private @Nullable String getPreviousPath(Database db, URI uri, String archivePath) throws QueryFailedException {
        String previousPath = null;
        XLink rootxl = uri.getXLink();
        if (rootxl != null) {
            List reps = DatabaseQuery.getRepliesByGroupContentRoleDates((Database)db, (XLink)rootxl, null, (String[])new String[]{"uri-properties"}, null, null, null);
            Collections.reverse(reps);
            for (XLink rep : reps) {
                Map props = ObjectProperties.toMap((String)rep.getProperties());
                List paths = (List)props.get("path");
                String path = paths != null && !paths.isEmpty() ? (String)paths.get(0) : null;
                if (path == null || path.startsWith(archivePath + "/")) continue;
                previousPath = path;
                break;
            }
            if (previousPath == null) {
                String path;
                Map props = ObjectProperties.toMap((String)rootxl.getProperties());
                List paths = (List)props.get("path");
                String string = path = paths != null && !paths.isEmpty() ? (String)paths.get(0) : null;
                if (path != null && !path.startsWith(archivePath + "/")) {
                    previousPath = path;
                }
            }
        }
        return previousPath;
    }
}

