/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class UnarchiveExternalURI
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnarchiveExternalURI.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditAllURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        URI uri = req.getURI();
        Member member = req.getMember();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("uri-unarchive");
        LOGGER.debug("Unarchiving URL {}", (Object)uri.getId());
        uri.setArchived(Boolean.FALSE);
        uri.setDateArchived(null);
        uri.setLastModified(new Date());
        URIRule.addURIHistoryXLink((URI)uri, (Member)member, (Database)db);
        URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
        req.getTransaction().commitAndStart();
        ChangesManager.getInstance().modifyURI(db, uri, Collections.emptyList());
        PSML.indexXRefSourceTargetURIs(db, uri, "External URI unarchived");
        out.writeExternalURI(uri);
        out.endObject();
        out.flush();
    }
}

