/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.common.util.Strings;
import com.pageseeder.uri.URIErrorID;
import org.eclipse.jdt.annotation.Nullable;

public final class URIUtils {
    private static final String VALID_LABELS = "[a-zA-Z0-9_\\-,]*";
    private static final String VALID_PRIORITY = "[a-zA-Z0-9, _-]+";
    private static final String VALID_STATUS = "[a-zA-Z0-9, _-]+";

    private URIUtils() {
    }

    public static boolean checkLabels(@Nullable GeneratorResponse res, @Nullable String labels) {
        if (Strings.isEmpty((String)labels) || labels.matches(VALID_LABELS)) {
            return true;
        }
        if (res != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.LABELS_INVALID);
        }
        return false;
    }

    public static boolean checkPriority(@Nullable GeneratorResponse res, @Nullable String priority) {
        if (Strings.isEmpty((String)priority) || priority.matches("[a-zA-Z0-9, _-]+")) {
            return true;
        }
        if (res != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.PRIORITY_INVALID);
        }
        return false;
    }

    public static boolean checkStatus(@Nullable GeneratorResponse res, @Nullable String status) {
        if (Strings.isEmpty((String)status) || status.matches("[a-zA-Z0-9, _-]+")) {
            return true;
        }
        if (res != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.STATUS_INVALID);
        }
        return false;
    }
}

