/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIEditLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIEditLock.class);
    private static final int LOCK_TIMEOUT = 30000;
    private static final int LOCK_EXPIRES = 300000;
    private static final int MAX_LOCKS = 1000;
    private static final Map<Long, URIEditLock> LOCKS = new ConcurrentHashMap<Long, URIEditLock>();
    private final ReentrantLock _lock = new ReentrantLock(true);
    private long _lastAcquired = System.currentTimeMillis();
    private long _uriid;

    private URIEditLock(long uriid) {
        this._uriid = uriid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URIEditLock newInstance(long uriid) {
        Class<URIEditLock> clazz = URIEditLock.class;
        synchronized (URIEditLock.class) {
            URIEditLock l;
            if (LOCKS.size() > 1000) {
                for (URIEditLock fl : LOCKS.values()) {
                    if (fl._lastAcquired + 300000L >= System.currentTimeMillis()) continue;
                    LOCKS.remove(fl._uriid);
                    LOGGER.error("Lock for URI ID {} removed because of too many locks", (Object)fl._uriid);
                }
            }
            if ((l = LOCKS.get(uriid)) != null) {
                if (l._lastAcquired + 300000L < System.currentTimeMillis()) {
                    LOCKS.remove(uriid);
                    LOGGER.warn("Lock for URI ID {} removed because it expired", (Object)uriid);
                    l = new URIEditLock(uriid);
                    LOCKS.put(uriid, l);
                    LOGGER.debug("Lock for URI ID {} created", (Object)uriid);
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return l;
                }
                LOGGER.debug("Lock for URI ID {} returned", (Object)uriid);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return l;
            }
            l = new URIEditLock(uriid);
            LOCKS.put(uriid, l);
            LOGGER.debug("Lock for URI ID {} created", (Object)uriid);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return l;
        }
    }

    public boolean lock() {
        boolean acquired = false;
        try {
            acquired = this._lock.tryLock(30000L, TimeUnit.MILLISECONDS);
            if (acquired) {
                this._lastAcquired = System.currentTimeMillis();
                LOGGER.debug("Lock for URI ID {} acquired", (Object)this._uriid);
            } else {
                LOGGER.error("Lock for URI ID {} not acquired due to timeout", (Object)this._uriid);
            }
            return acquired;
        }
        catch (InterruptedException e) {
            LOGGER.error("Lock for URI ID {} not acquired due to interrupt", (Object)this._uriid);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Class<URIEditLock> clazz = URIEditLock.class;
        synchronized (URIEditLock.class) {
            if (!this._lock.hasQueuedThreads()) {
                boolean result = LOCKS.remove(this._uriid, this);
                LOGGER.debug("Lock for URI ID {} removed {}", (Object)this._uriid, (Object)result);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._lock.unlock();
            LOGGER.debug("Lock for URI ID {} released", (Object)this._uriid);
            return;
        }
    }
}

