/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.Thumbnails;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.uri.URILocker;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefMediator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public final class MoveURIThread
extends ProcessThread {
    private static final String PUBLIC_GROUP = "public";
    private final Map<Long, URIToMove> urisToMove = new HashMap<Long, URIToMove>();
    private final List<Long> commentsToIndex = new ArrayList<Long>();
    private final List<URIToIndex> urisToIndex = new ArrayList<URIToIndex>();
    private boolean logMessages = true;
    private String destinationScheme = null;
    private String destinationHost = null;
    private Integer destinationPort = null;
    private final boolean archiving;
    private String destinationPath = null;
    private Long destinationURIID = null;
    private Long destinationGroupURIID = null;
    private String destinationURL = null;
    private Destination destination = null;
    private final Collection<String> commentGroups = new ArrayList<String>();
    private boolean removexrefs = false;
    private boolean resolve = false;
    private static final int DEFAULT_HTTP_PORT = 80;
    private String archivePath = null;
    private File archiveDirectory = null;
    private int currentProgress = 0;
    private int totalUris = 0;
    private String lastError = null;
    private final Map<String, File> filesToMove = new HashMap<String, File>();
    private final List<File> movedFiles = new ArrayList<File>();
    private final List<URIToIndex> movedURIs = new ArrayList<URIToIndex>();
    private final Map<String, GroupURI> movedGroupURIs = new HashMap<String, GroupURI>();
    private Map<String, String> filesMoved = new HashMap<String, String>();
    private List<File> foldersCreated = new ArrayList<File>();
    private List<File> foldersDeleted = new ArrayList<File>();

    private MoveURIThread(boolean archive, String membername, Group group) {
        super(membername, (archive ? "Archiving " : "Moving ") + "thread for group " + group.getName(), group);
        this.archiving = archive;
    }

    public void setLogMessages(boolean logmessages) {
        this.logMessages = logmessages;
    }

    public void setCommentGroups(Collection<String> commentgroups) {
        if (commentgroups != null) {
            this.commentGroups.addAll(commentgroups);
        } else {
            this.commentGroups.clear();
        }
    }

    public void addURIToMove(Long uriid, String newName) {
        this.urisToMove.put(uriid, new URIToMove(uriid, newName));
    }

    public void setDestinationURIID(Long destinationid) {
        this.destinationURIID = destinationid;
    }

    public void setDestinationGroupURIID(Long destinationGURIID) {
        this.destinationGroupURIID = destinationGURIID;
    }

    public void setDestinationURL(String destinationuRL) {
        this.destinationURL = destinationuRL;
    }

    public void setDestinationDetails(String scheme, String host, Integer port, String path) {
        this.destinationScheme = scheme;
        this.destinationPort = port;
        this.destinationHost = host;
        this.destinationPath = path;
    }

    public void setRemoveXRefs(boolean removexrefs) {
        this.removexrefs = removexrefs;
    }

    public void setResolveXRefs(boolean resolve) {
        this.resolve = resolve;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.totalUris);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    public void process() {
        this.run(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Database database, Transaction transaction) {
        if (this.urisToMove.isEmpty()) {
            this.fail("No URI to " + (this.archiving ? "archive" : "move") + "!");
            this.complete("Failed");
            return false;
        }
        Transaction tr = transaction;
        Database db = database;
        boolean newTransaction = false;
        if (db == null && tr == null) {
            try {
                db = Database.open();
                tr = new Transaction(db);
                newTransaction = true;
            }
            catch (OpenDatabaseException e) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database", this.logMessages);
                return false;
            }
        }
        try {
            if (newTransaction) {
                tr.begin();
            }
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername());
            this.archivePath = GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/archive";
            this.archiveDirectory = new File(URIRule.getRealPath((String)this.archivePath));
            this.resolveDestinationURI(db);
            if (this.destination == null) {
                boolean bl = false;
                return bl;
            }
            String destinationFolder = URIRule.getRealPath((String)Settings.getContextPath(), (String)this.destination.getPath());
            File destinationDir = new File(destinationFolder);
            if (!destinationDir.exists() || !destinationDir.isDirectory()) {
                if ((this.destinationPath + "/").startsWith(this.archivePath + "/")) {
                    if (!destinationDir.mkdirs()) {
                        this.fail("Failed to create archive folder " + this.filterPath(destinationDir));
                        this.complete("Failed");
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.fail("Invalid destination folder " + this.filterPath(destinationDir));
                    this.complete("Failed");
                    boolean bl = false;
                    return bl;
                }
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing URIs to " + (this.archiving ? "archive" : "move"), this.logMessages);
            this.cleanURIsToMove(db);
            if (this.hasError() || this.wasCancelled()) {
                if (newTransaction) {
                    tr.abort();
                }
                if (this.lastError != null) {
                    this.fail(this.lastError);
                }
                this.complete("Failed");
                boolean bl = false;
                return bl;
            }
            this.totalUris = 0;
            ArrayList<String> filesAdded = new ArrayList<String>();
            for (Long l : this.urisToMove.keySet()) {
                URIToMove toMove = this.urisToMove.get(l);
                File sourceFile = toMove.getSourceFile();
                String otherThreadID = null;
                try {
                    otherThreadID = URILocker.getLocker(sourceFile.getCanonicalPath());
                }
                catch (IOException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Failed to check if file " + sourceFile.getName() + " is moving: " + ex.getMessage());
                }
                if (otherThreadID != null) {
                    if (otherThreadID.equals(this.getThreadID())) {
                        this.error("Cannot move two files with the same name to the same destination (" + sourceFile.getName() + ").");
                        break;
                    }
                    this.error("There is already a move/archive action running within this context (" + toMove.getURI().getDecodedPath() + ").");
                    break;
                }
                File targetFile = this.preMoveFile(sourceFile, destinationFolder, toMove.newName());
                this.totalUris += 1 + DatabaseQuery.getURICountBySchemeHostPortPathLike((Database)db, (String)toMove.uri.getScheme(), (String)toMove.uri.getHost().getName(), (Integer)toMove.uri.getPort(), (String)(toMove.uri.getPath() + "/%"), null);
                if (this.wasCancelled() || this.hasError()) break;
                if (targetFile == null) continue;
                try {
                    String spath = sourceFile.getCanonicalPath();
                    URILocker.lock(spath, this.getThreadID());
                    filesAdded.add(spath);
                }
                catch (IOException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Failed to add file " + sourceFile.getName() + " to list of moving files: " + ex.getMessage());
                }
                try {
                    String tpath = targetFile.getCanonicalPath();
                    URILocker.lock(tpath, this.getThreadID());
                    filesAdded.add(tpath);
                }
                catch (IOException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Failed to add file " + this.filterPath(targetFile) + " to list of moving files: " + ex.getMessage());
                }
            }
            boolean success = !this.hasError() && !this.wasCancelled();
            try {
                if (success) {
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.totalUris + " URIs to " + (this.archiving ? "archive" : "move"), this.logMessages);
                    this.totalUris *= this.resolve ? 3 : 2;
                    for (Long uriid : this.urisToMove.keySet()) {
                        URIToMove toMove = this.urisToMove.get(uriid);
                        this.moveDatabaseObject(toMove.getURI(), member, toMove.getSourceFile(), toMove.getSourceFile().getParentFile(), destinationFolder, false, group, db, tr);
                        if (!this.hasError() && !this.wasCancelled()) continue;
                        break;
                    }
                    boolean bl = success = !this.hasError() && !this.wasCancelled();
                    if (success) {
                        success = this.moveAndCommit(tr, false);
                    }
                }
            }
            finally {
                for (String path : filesAdded) {
                    URILocker.unlock(path);
                }
            }
            int n = this.urisToIndex.size();
            if (!success) {
                tr.abort();
                tr.begin();
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Reverting any documents already committed");
                this.revertMove(member, group, db, tr);
                if (this.lastError != null) {
                    this.fail(this.lastError);
                }
            } else if (n > 0) {
                if (this.resolve) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException path) {
                        // empty catch block
                    }
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Resolving xrefs");
                    this.resolveXRefs(this.urisToIndex, group, member, db, tr);
                }
                ChangesManager changes = ChangesManager.getInstance();
                String batchName = (this.archiving ? "Archiving " : "Moving ") + n + " file" + (n == 1 ? "" : "s") + "/folder" + (n == 1 ? "" : "s");
                ChangesBatch batch = new ChangesBatch(batchName);
                changes.startBatch(db, batch);
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Indexing documents and folders");
                for (URIToIndex suburi : this.urisToIndex) {
                    ++this.currentProgress;
                    URI u = DatabaseQuery.getURIById((Database)db, (Long)suburi.uriid);
                    XLink workflow = URIRule.getRootWorkflowForURI((Database)db, (URI)u);
                    if (!suburi.removedGroups.isEmpty()) {
                        changes.deleteURI(db, batch, u, suburi.removedGroups());
                        if (workflow != null) {
                            changes.deleteWorkflow(db, batch, workflow.getId(), suburi.removedGroups());
                        }
                        if (suburi.guri != null) {
                            changes.deleteGroupfolder(db, batch, suburi.guri.getId(), suburi.guri.getPath(), suburi.removedGroups());
                        }
                    }
                    if (this.archiving) {
                        changes.archiveURI(db, batch, u, suburi.modifiedGroups());
                        if (workflow != null) {
                            changes.deleteWorkflow(db, batch, workflow.getId(), suburi.modifiedGroups());
                        }
                        if (suburi.guri != null) {
                            changes.deleteGroupfolder(db, batch, suburi.guri.getId(), suburi.guri.getPath(), suburi.modifiedGroups());
                        }
                    } else if (!suburi.modifiedGroups.isEmpty()) {
                        changes.modifyURI(db, batch, u, suburi.modifiedGroups());
                        if (workflow != null && suburi.unarchived) {
                            changes.createWorkflow(db, batch, workflow, suburi.modifiedGroups());
                        }
                        if (suburi.guri != null) {
                            changes.modifyGroupfolder(db, batch, suburi.guri, suburi.modifiedGroups());
                        }
                    }
                    if (!suburi.addedGroups.isEmpty()) {
                        changes.createURI(db, batch, u, suburi.addedGroups());
                        if (workflow != null) {
                            changes.createWorkflow(db, batch, workflow, suburi.addedGroups());
                        }
                        if (suburi.guri != null) {
                            changes.createGroupfolder(db, batch, suburi.guri, suburi.addedGroups());
                        }
                    }
                    Collection uris = DatabaseQuery.getURIsByURIXRefsAllGroups((Database)db, (URI)u, (boolean)this.removexrefs);
                    for (URI uri2 : uris) {
                        changes.modifyURI(db, batch, uri2);
                    }
                    if (suburi.modifiedGroups.isEmpty() && suburi.addedGroups.isEmpty()) continue;
                    Publications.updateURI((URI)u);
                }
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Indexing comments");
                if (!this.commentGroups.isEmpty()) {
                    XLink xl;
                    Collection groups = GroupRule.getGroupsByNames((Database)db, this.commentGroups);
                    if (!groups.contains(group)) {
                        for (Long id : this.commentsToIndex) {
                            changes.deleteComment(db, batch, id, Collections.singleton(group));
                            xl = DatabaseQuery.getXLinkById((Database)db, (Long)id);
                            if (xl == null || xl.getStatus() == null) continue;
                            changes.taskUpdated(db, batch, XLinks.getThreadRoot((XLink)xl).getId(), Collections.singleton(group));
                        }
                    } else {
                        groups.remove(group);
                    }
                    if (!groups.isEmpty()) {
                        for (Long id : this.commentsToIndex) {
                            xl = DatabaseQuery.getXLinkById((Database)db, (Long)id);
                            changes.createComment(db, batch, xl, groups);
                        }
                    }
                }
                changes.completeBatch(db, batch);
            }
            if (newTransaction) {
                tr.commit();
            } else {
                tr.commitAndStart();
            }
            this.complete("Successfully " + (this.archiving ? "archived " : "moved ") + n + " file" + (n == 1 ? "" : "s") + "/folder" + (n == 1 ? "" : "s") + (this.hasWarning() ? " with some warnings, see logs" : ""));
            boolean bl = success;
            return bl;
        }
        catch (StartTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to start transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
            boolean bl = false;
            return bl;
        }
        catch (CommitTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to commit transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
            boolean bl = false;
            return bl;
        }
        catch (DatabaseException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to run database query: " + e.getMessage(), this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (newTransaction) {
                db.close();
                db = null;
            }
        }
    }

    private void resolveXRefs(List<URIToIndex> moved, Group group, Member author, Database db, Transaction tr) throws DatabaseException {
        for (URIToIndex uti : moved) {
            List<String> errors;
            List<String> warnings;
            ++this.currentProgress;
            URI u = DatabaseQuery.getURIById((Database)db, (Long)uti.uriid);
            Date now = new Date();
            XRefMediator mediator = new XRefMediator(group, u, author, now, db);
            mediator.setCreateEdit(true);
            mediator.setFailOnFirstError(false);
            DocumentContentResolver resolver = new DocumentContentResolver(u.getId(), group.getName());
            resolver.setPSMLFormat(true);
            try {
                mediator.mediateNewDocument(resolver.getContent(db));
            }
            catch (XRefException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to load XRefs for " + u.getDecodedPath() + ": " + ex.getMessage() + " (URIID " + u.getId() + ")");
            }
            catch (URIException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to load content for " + u.getDecodedPath() + ": " + ex.getMessage() + " (URIID " + u.getId() + ")");
            }
            int nb = mediator.getNbOfXrefsCreated();
            if (nb > 0) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Created " + nb + " cross-references for document " + u.getDecodedPath() + " (URIID " + u.getId() + ")");
                u.setLastModified(now);
                tr.commitAndStart();
            }
            if ((warnings = mediator.getWarnings()) != null && !warnings.isEmpty()) {
                for (String err : warnings) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Warning for " + u.getDecodedPath() + ": " + err);
                }
            }
            if ((errors = mediator.getErrors()) != null && !errors.isEmpty()) {
                for (String err : errors) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Error for " + u.getDecodedPath() + ": " + err + " (URIID " + u.getId() + ")");
                }
            }
            if (!this.wasCancelled()) continue;
            tr.abort();
        }
    }

    private void revertMove(Member member, Group group, Database db, Transaction tr) throws DatabaseException {
        boolean resolving = this.archiving && this.removexrefs;
        this.currentProgress = 0;
        this.totalUris = this.urisToIndex.size() * (resolving ? 2 : 1);
        this.movedFiles.clear();
        this.movedURIs.clear();
        for (Map.Entry<String, GroupURI> entry : this.movedGroupURIs.entrySet()) {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Reverting group folder: " + entry.getKey());
            entry.getValue().setPath(entry.getKey());
        }
        if (!this.urisToIndex.isEmpty()) {
            URIToIndex last = this.urisToIndex.get(this.urisToIndex.size() - 1);
            URI lastUri = DatabaseQuery.getURIById((Database)db, (Long)last.uriid);
            File lastParent = new File(URIRule.getRealPath((String)lastUri.getPath())).getParentFile();
            for (URIToIndex uti : this.urisToIndex) {
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)uti.uriid);
                File file = new File(URIRule.getRealPath((String)uri.getPath()));
                this.moveDatabaseObject(uri, member, file, file.getParentFile(), uti.sourceFolder, true, group, db, tr);
            }
            this.moveAndCommit(tr, true);
            File dest = new File(URIRule.getRealPath((String)this.destination.getPath()));
            while (lastParent != null && !dest.equals(lastParent)) {
                if (lastParent.exists() && !lastParent.delete()) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Failed to delete target directory " + lastParent.getName());
                } else {
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Deleted target directory " + lastParent.getName());
                }
                lastParent = lastParent.getParentFile();
            }
        }
        if (resolving) {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Resolving xrefs for documents already committed before cancel");
            this.resolveXRefs(this.urisToIndex, group, member, db, tr);
        }
    }

    private void cleanURIsToMove(Database db) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Long uriid : this.urisToMove.keySet()) {
            URIToMove utm = this.urisToMove.get(uriid);
            try {
                utm.computeURI(db);
            }
            catch (QueryFailedException e) {
                this.error("Failed to retrieve URI with ID " + uriid);
                continue;
            }
            paths.add(utm.getURI().getPath());
        }
        ArrayList<Long> toremove = new ArrayList<Long>();
        for (Long uriid : this.urisToMove.keySet()) {
            URI u = this.urisToMove.get(uriid).getURI();
            if (u == null) continue;
            for (String path : paths) {
                if (!u.getPath().startsWith(path + "/")) continue;
                toremove.add(uriid);
            }
        }
        while (!toremove.isEmpty()) {
            this.urisToMove.remove(toremove.remove(0));
        }
    }

    private void resolveDestinationURI(Database db) throws QueryFailedException {
        if (this.destinationURIID != null && this.destinationURIID != -1L) {
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)this.destinationURIID);
            if (uri == null) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to retrieve destination folder with URI ID " + this.destinationURIID, this.logMessages);
                return;
            }
            this.destination = new Destination(uri);
        } else if (this.destinationGroupURIID != null && this.destinationGroupURIID != -1L) {
            GroupURI gu = DatabaseQuery.getGroupURIById((Database)db, (Long)this.destinationGroupURIID);
            if (gu == null) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to retrieve destination folder with GroupURI ID " + this.destinationGroupURIID, this.logMessages);
                return;
            }
            this.destination = new Destination(gu);
        } else if (this.destinationPath != null && this.destinationHost != null && this.destinationScheme != null && this.destinationPort != null) {
            String path = this.destinationPath.replaceAll("/$", "");
            URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)this.destinationScheme, (String)this.destinationHost, (Integer)this.destinationPort, (String)path);
            if (uri == null) {
                if (this.destinationPath.equals(this.archivePath)) {
                    try {
                        uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType((Database)db, null, (String)this.destinationScheme, (String)this.destinationHost, (Integer)this.destinationPort, (String)this.destinationPath, null, null, null, (String)"folder", (boolean)false);
                    }
                    catch (DatabaseException e) {
                        this.updateStatus(ProcessStage.Status.FAILED, "Failed to create archive folder URI: " + e.getMessage(), this.logMessages);
                        return;
                    }
                    this.destination = new Destination(uri);
                } else if (this.destinationPath.startsWith(this.archivePath + "/")) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Invalid archive folder does not exist in the DB: " + this.destinationPath, this.logMessages);
                } else {
                    GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)this.destinationScheme, (String)this.destinationHost, (Integer)this.destinationPort, (String)this.destinationPath);
                    if (guri == null) {
                        this.updateStatus(ProcessStage.Status.FAILED, "Failed to retrieve destination folder with details " + this.destinationScheme + "://" + this.destinationHost + ":" + this.destinationPort + this.destinationPath, this.logMessages);
                        return;
                    }
                    this.destination = new Destination(guri);
                }
            } else {
                this.destination = new Destination(uri);
            }
        } else if (this.destinationURL != null) {
            URL turl;
            try {
                turl = new URL(this.destinationURL.replaceAll("/$", ""));
            }
            catch (MalformedURLException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Invalid URL: " + this.destinationURL, this.logMessages);
                return;
            }
            this.destinationHost = HostRule.resolveAlias((Database)db, (String)turl.getHost());
            Host thost = DatabaseQuery.getHostByName((Database)db, (String)this.destinationHost);
            if (thost == null) {
                this.updateStatus(ProcessStage.Status.FAILED, "Host or alias not found: " + this.destinationHost, this.logMessages);
                return;
            }
            URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)turl.getProtocol(), (String)this.destinationHost, (Integer)(turl.getPort() == -1 ? 80 : turl.getPort()), (String)turl.getFile());
            if (uri == null) {
                GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)turl.getProtocol(), (String)this.destinationHost, (Integer)(turl.getPort() == -1 ? 80 : turl.getPort()), (String)turl.getFile());
                if (guri == null) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to retrieve destination folder with URL " + this.destinationURL, this.logMessages);
                    return;
                }
                this.destination = new Destination(guri);
            } else {
                this.destination = new Destination(uri);
            }
        } else {
            this.updateStatus(ProcessStage.Status.FAILED, "Missing details to retrieve destination", this.logMessages);
        }
    }

    private File preMoveFile(File sourceFile, String destinationFolder, String newName) {
        File[] files;
        File targetFile;
        if (this.wasCancelled()) {
            return null;
        }
        String filename = sourceFile.getName();
        String extension = "";
        int j = filename.lastIndexOf(46);
        if (!sourceFile.isDirectory() && j != -1) {
            extension = filename.substring(j);
            filename = filename.substring(0, j);
        }
        if (newName != null) {
            filename = RuleUtils.replaceNonFilenameChars((String)newName);
        }
        if (!(targetFile = new File(destinationFolder + File.separator + filename + extension)).getAbsolutePath().equalsIgnoreCase(sourceFile.getAbsolutePath()) && !this.handleOverwrite(targetFile)) {
            return null;
        }
        String otherThreadID = null;
        try {
            otherThreadID = URILocker.getLocker(targetFile.getCanonicalPath());
        }
        catch (IOException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to check if file " + this.filterPath(targetFile) + " is moving: " + ex.getMessage());
        }
        if (otherThreadID != null) {
            if (otherThreadID.equals(this.getThreadID())) {
                this.error("Cannot move two files with the same name to the same destination (" + targetFile.getName() + ").");
            } else {
                this.error("There is already a move/archive action running within this context (" + this.filterPath(targetFile) + ").");
            }
            return null;
        }
        if (this.wasCancelled()) {
            return null;
        }
        this.filesToMove.put(sourceFile.getPath(), targetFile);
        if (!sourceFile.exists()) {
            if (!URIRule.isPSML((File)sourceFile)) {
                this.updateStatus(ProcessStage.Status.WARNING, "File " + sourceFile.getName() + " does not exist, the URI will be moved", this.logMessages);
            }
        } else if (sourceFile.isDirectory() && (files = sourceFile.listFiles()) != null) {
            for (File subFile : files) {
                this.preMoveFile(subFile, destinationFolder + File.separator + filename, null);
                if (!this.wasCancelled()) continue;
                return null;
            }
        }
        return targetFile;
    }

    /*
     * WARNING - void declaration
     */
    private void moveDatabaseObject(URI uri, Member member, File sourceFile, File parentFolder, String destinationFolder, boolean revert, Group group, Database db, Transaction tr) {
        boolean newHost;
        boolean archive;
        URI targetURI;
        if (this.wasCancelled() && !revert) {
            return;
        }
        String originalScheme = uri.getScheme();
        String originalHost = uri.getHost().getName();
        Integer originalPort = uri.getPort();
        String originalPath = uri.getPath();
        File targetFile = this.filesToMove.get(sourceFile.getPath());
        boolean moveFile = false;
        if (targetFile == null) {
            String relativePath;
            if (sourceFile.exists()) {
                this.error("Found URI " + uri.getId() + " with no target file attached (source is " + sourceFile.getPath() + ")");
                return;
            }
            try {
                relativePath = Files.path((File)parentFolder, (File)sourceFile);
            }
            catch (IOException e) {
                this.error("Found URI " + uri.getId() + " with no target file attached (source is " + sourceFile.getPath() + ") and failed to create fake target file: " + e.getMessage());
                return;
            }
            targetFile = new File(destinationFolder + File.separator + relativePath);
        } else {
            moveFile = true;
            this.filesToMove.put(targetFile.getPath(), sourceFile);
        }
        String filterPath = this.filterPath(targetFile, revert);
        String targetPath = RuleUtils.urlEncodeFilepath((String)(revert ? GlobalSettings.getSitePrefix() + "/" + filterPath : this.destination.getDecodedPath() + "/" + filterPath));
        try {
            targetURI = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)this.destination.getScheme(), (String)this.destination.getHost().getName(), (Integer)this.destination.getPort(), (String)targetPath);
        }
        catch (QueryFailedException e) {
            this.error("Failed to load target URI: " + e.getMessage());
            return;
        }
        if (!targetFile.getAbsolutePath().equalsIgnoreCase(sourceFile.getAbsolutePath()) && !this.handleOverwrite(targetURI)) {
            return;
        }
        GroupURI guri = null;
        if (URIRule.isFolder((URI)uri)) {
            try {
                guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)(uri.getPath() + "/*"));
            }
            catch (QueryFailedException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to find group URI for URI " + uri.getId(), this.logMessages);
            }
        }
        boolean sharedTarget = false;
        if (guri != null) {
            try {
                for (GroupURI tguri : DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol((Database)db, (String)this.destination.getScheme(), (String)this.destination.getHost().getName(), (Integer)this.destination.getPort(), (String)targetPath, (boolean)false, (boolean)true)) {
                    if (!GroupURIRule.isShared((Database)db, (GroupURI)tguri)) continue;
                    sharedTarget = true;
                    break;
                }
            }
            catch (QueryFailedException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to find group URI for URI " + uri.getId(), this.logMessages);
            }
        }
        if (guri != null && !sharedTarget) {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Updating group folder: " + guri.getPath());
            this.movedGroupURIs.put(guri.getPath(), guri);
            guri.setPath(targetPath + "/*");
        }
        if ("folder".equals(uri.getType()) && !revert) {
            Collection subURIs;
            try {
                subURIs = DatabaseQuery.getURIsBySchemeHostPortDirectoryMediaDocumentType((Database)db, (String)originalScheme, (String)originalHost, (Integer)originalPort, (String)(originalPath + "/"), null, null, (boolean)true);
            }
            catch (QueryFailedException e) {
                this.error("Failed to load sub-URIs: " + e.getMessage());
                return;
            }
            ArrayList<Long> subURIIDs = new ArrayList<Long>(subURIs.size());
            for (URI u : subURIs) {
                subURIIDs.add(u.getId());
            }
            subURIs = null;
            File subRoot = new File(URIRule.getRealPath((String)originalPath));
            String subDestination = URIRule.getRealPath((String)targetPath);
            for (Long l : subURIIDs) {
                URI subURI = null;
                try {
                    subURI = DatabaseQuery.getURIById((Database)db, (Long)l);
                }
                catch (QueryFailedException ex) {
                    this.error("Failed to load subURIID " + l + ": " + ex.getMessage());
                    return;
                }
                File source = new File(URIRule.getRealPath((String)subURI.getPath()));
                this.moveDatabaseObject(subURI, member, source, subRoot, subDestination, false, group, db, tr);
                if (!this.wasCancelled() && !this.hasError()) continue;
                return;
            }
        }
        ArrayList oldGroups = new ArrayList();
        try {
            oldGroups.addAll(DatabaseQuery.getGroupsByURIIdColNameNotEquals((Database)db, (Long)uri.getId(), (String[])new String[]{PUBLIC_GROUP}));
        }
        catch (QueryFailedException e1) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to load index groups for URI " + uri.getId(), this.logMessages);
        }
        boolean unarchive = uri.getPath().startsWith(this.archivePath) && !targetPath.startsWith(this.archivePath);
        boolean bl = archive = !uri.getPath().startsWith(this.archivePath) && targetPath.startsWith(this.archivePath);
        if (archive && this.removexrefs) {
            try {
                Date changed = new Date();
                List xrefs = DatabaseQuery.getXRefsForwardURIGroupFragment((Database)db, (URI)uri, (Group)GroupRule.getEditGroup((Database)db, (Group)group, (URI)uri), null);
                for (XLink xl : xrefs) {
                    xl.setStatus("Documentation-Old");
                    xl.setStatusChangedDate(changed);
                    URI target = new XRef(xl).getTargetURI();
                    if (target == null) continue;
                    target.setLastModified(changed);
                }
            }
            catch (DatabaseException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to load forward xrefs URI " + uri.getId(), this.logMessages);
            }
        }
        String docid = uri.getDocID();
        boolean bl2 = newHost = !this.destination.getHost().getName().equals(uri.getHost().getName());
        if (docid != null && (newHost || unarchive)) {
            void var26_41;
            Object var26_39 = null;
            try {
                URI uRI = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)this.destination.getHost().getName(), (String)docid);
            }
            catch (QueryFailedException e) {
                this.error("Failed to load another URI with Document ID " + docid + ": " + e.getMessage());
            }
            if (var26_41 != null && var26_41.getId().longValue() != uri.getId().longValue()) {
                this.error("Cannot move " + uri.getDisplayTitle() + " (URIID " + uri.getId() + ") because the document with the path " + var26_41.getDecodedPath() + " already has the document ID " + docid);
                return;
            }
        }
        try {
            List list = DatabaseQuery.getPublicationsByRootURIGroups((Database)db, (Long)uri.getId(), (Collection)oldGroups.stream().map(Group::getName).collect(Collectors.toList()), (boolean)true);
            if (list != null && !list.isEmpty()) {
                if (newHost || unarchive) {
                    Publication publication = (Publication)list.get(0);
                    XLink pub_xlink = DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
                    Publication otherOne = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publication.getId(), (Host)this.destination.getHost());
                    if (otherOne != null) {
                        Object newId = publication.getId() + "-" + System.currentTimeMillis();
                        if (((String)newId).length() > 250) {
                            newId = ((String)newId).substring(((String)newId).length() - 250);
                        }
                        if ((otherOne = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)newId, (Host)this.destination.getHost())) != null) {
                            this.error("Cannot move " + uri.getDisplayTitle() + " (URIID " + uri.getId() + ") because the document with ID " + otherOne.getRootURIId() + " already has the publication " + (String)newId + " (try again)");
                            return;
                        }
                        pub_xlink.setContentTitle((String)newId);
                    }
                    if (unarchive) {
                        XLinkRule.unarchiveXLink((XLink)pub_xlink);
                        Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)"default");
                        loc.addPublications(pub_xlink);
                    }
                } else if (archive) {
                    for (Object publication : list) {
                        XLink pub_xlink = DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
                        XLinkRule.archiveXLink((XLink)pub_xlink);
                        Collection locators = DatabaseQuery.getLocatorsForPublication((Database)db, (XLink)pub_xlink);
                        for (Locator locator : locators) {
                            locator.removePublications(pub_xlink);
                        }
                        PublicationManager.singleton().clearCachedTOC((Publication)publication);
                    }
                }
            }
        }
        catch (DatabaseException databaseException) {
            this.error("Failed to check for publication: " + databaseException.getMessage());
            return;
        }
        if (archive) {
            Thumbnails.deleteThumbnails((long)uri.getId(), (String)uri.getType());
        }
        ++this.currentProgress;
        this.updateStatus(ProcessStage.Status.INPROGRESS, (revert ? "Reverting" : (archive ? "Archiving" : "Moving")) + " URI " + uri.getId() + " - " + filterPath, this.logMessages);
        URIToIndex uRIToIndex = new URIToIndex(uri.getId(), guri, unarchive, parentFolder.getAbsolutePath());
        if (this.updateURIObject(db, uri, member, this.destination.getScheme(), this.destination.getHost().getName(), this.destination.getPort(), targetPath, unarchive, archive)) {
            try {
                Collection newGroups = DatabaseQuery.getGroupsByURIIdColNameNotEquals((Database)db, (Long)uri.getId(), (String[])new String[]{PUBLIC_GROUP});
                if (guri != null && sharedTarget) {
                    guri.setPath(targetPath + "/*");
                    for (Group gp : guri.getGroupsCol()) {
                        if (newGroups.contains(gp)) continue;
                        gp.removeGroupURIs(guri);
                    }
                }
                uRIToIndex.addedGroups.addAll(newGroups);
                uRIToIndex.addedGroups.removeAll(oldGroups);
                uRIToIndex.removedGroups.addAll(oldGroups);
                uRIToIndex.removedGroups.removeAll(newGroups);
                uRIToIndex.modifiedGroups.addAll(oldGroups);
                uRIToIndex.modifiedGroups.retainAll(newGroups);
            }
            catch (QueryFailedException e1) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to load index groups for URI " + uri.getId(), this.logMessages);
            }
            Date change_date = new Date();
            uri.setLastModified(change_date);
            try {
                URIRule.updateLastModifedForXRefs((URI)uri, (Date)change_date, (Database)db);
            }
            catch (QueryFailedException ex) {
                this.error("Failed to update last modified for XRefs URIID " + uri.getId() + ": " + ex.getMessage());
                return;
            }
            this.movedURIs.add(uRIToIndex);
            if (moveFile) {
                this.movedFiles.add(sourceFile);
            }
        }
        if ((this.wasCancelled() || this.hasError()) && !revert) {
            return;
        }
        if (this.currentProgress % 1000 == 0) {
            this.moveAndCommit(tr, revert);
        }
    }

    private boolean moveAndCommit(Transaction tr, boolean revert) {
        if (this.movedFiles.isEmpty() && this.movedURIs.isEmpty()) {
            return true;
        }
        this.moveFilesForTransaction(revert);
        this.movedFiles.clear();
        if (this.hasError() && !revert) {
            return false;
        }
        try {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Committing to database");
            tr.commitAndStart();
        }
        catch (DatabaseException ex) {
            this.revertFilesMove();
            this.error("Failed to commit transaction: " + ex.getMessage());
            return false;
        }
        if (!revert) {
            this.urisToIndex.addAll(this.movedURIs);
        }
        this.movedURIs.clear();
        return true;
    }

    private void moveFilesForTransaction(boolean revert) {
        this.filesMoved = new HashMap<String, String>();
        this.foldersCreated = new ArrayList<File>();
        this.foldersDeleted = new ArrayList<File>();
        for (File source : this.movedFiles) {
            if (this.wasCancelled() && !revert) {
                this.revertFilesMove();
                return;
            }
            File target = this.filesToMove.get(source.getPath());
            if (target == null) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to find target file for " + source.getName(), this.logMessages);
                continue;
            }
            boolean changingCase = target.getAbsolutePath().equalsIgnoreCase(source.getAbsolutePath());
            if (source.isFile()) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, (revert ? "Reverting" : (this.archiving ? "Archiving" : "Moving")) + " File " + source.getName(), this.logMessages);
                if (target.exists() && !changingCase) {
                    this.error("Target file already exists: " + this.filterPath(target, revert));
                    continue;
                }
                File dad = target.getParentFile();
                if (!this.ensureTargetFolderExists(dad)) {
                    this.error("Failed to create folder " + this.filterPath(dad, revert));
                    continue;
                }
                try {
                    source.renameTo(target);
                    this.filesMoved.put(target.getAbsolutePath(), source.getAbsolutePath());
                }
                catch (Exception e) {
                    this.error("Failed to " + (this.archiving ? "archive" : "move") + " file " + this.filterPath(target, revert));
                }
                continue;
            }
            if (!source.isDirectory()) continue;
            this.updateStatus(ProcessStage.Status.INPROGRESS, (this.archiving ? "Archiving" : "Moving") + " Folder " + source.getName(), this.logMessages);
            if (changingCase) {
                if (source.renameTo(target)) continue;
                if (!source.delete()) {
                    this.error("Failed to delete source directory " + source.getName());
                    continue;
                }
                this.foldersDeleted.add(source);
                continue;
            }
            if (this.ensureTargetFolderExists(target)) {
                if (!source.delete()) {
                    this.error("Failed to delete source directory " + source.getName());
                    continue;
                }
                this.foldersDeleted.add(source);
                continue;
            }
            this.error("Failed to create directory " + this.filterPath(target, revert));
        }
        if (this.hasError()) {
            this.revertFilesMove();
        }
    }

    private boolean ensureTargetFolderExists(File dad) {
        if (dad.exists()) {
            return dad.isDirectory();
        }
        if (!this.ensureTargetFolderExists(dad.getParentFile())) {
            return false;
        }
        if (dad.mkdir()) {
            this.foldersCreated.add(dad);
            return true;
        }
        return false;
    }

    private void revertFilesMove() {
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Reverting " + this.filesMoved.size() + " files and " + (this.foldersCreated.size() + this.foldersDeleted.size()) + " folders");
        for (Map.Entry<String, String> file : this.filesMoved.entrySet()) {
            File target = new File(file.getKey());
            File source = new File(file.getValue());
            if (source.exists()) continue;
            try {
                FileUtils.moveFile((File)target, (File)source);
            }
            catch (IOException e) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to revert file " + String.valueOf(target) + " to " + String.valueOf(source) + ": " + e.getMessage());
            }
        }
        while (!this.foldersCreated.isEmpty()) {
            ArrayList<File> removed = new ArrayList<File>();
            for (File folder : this.foldersCreated) {
                if (folder.exists()) {
                    if (!folder.delete()) continue;
                    removed.add(folder);
                    continue;
                }
                removed.add(folder);
            }
            if (removed.isEmpty()) break;
            this.foldersCreated.removeAll(removed);
        }
        if (!this.foldersCreated.isEmpty()) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to revert creation of " + this.foldersCreated.size() + " folder(s)");
        }
        while (!this.foldersDeleted.isEmpty()) {
            ArrayList<File> created = new ArrayList<File>();
            for (File folder : this.foldersDeleted) {
                if (!folder.exists() && !folder.mkdir()) continue;
                created.add(folder);
            }
            if (created.isEmpty()) break;
            this.foldersDeleted.removeAll(created);
        }
        if (!this.foldersDeleted.isEmpty()) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to revert deletion of '" + this.foldersCreated.size() + "' folder(s)");
        }
    }

    public void error(String message) {
        this.lastError = message;
        super.updateStatus(ProcessStage.Status.ERROR, message, this.logMessages);
    }

    private boolean handleOverwrite(File existing) {
        if (existing.exists()) {
            this.error("Destination file '" + this.filterPath(existing) + "' already exists");
            return false;
        }
        return true;
    }

    private boolean handleOverwrite(URI target) {
        if (target != null) {
            this.error("Destination URI " + target.getDecodedPath() + "(URIID " + target.getId() + ") already exists");
            return false;
        }
        return true;
    }

    private String filterPath(File fullPath) {
        return this.filterPath(fullPath, false);
    }

    private String filterPath(File fullPath, boolean revert) {
        if (this.destination == null) {
            return fullPath.getName();
        }
        String destinationFolder = URIRule.getRealPath((String)Settings.getContextPath(), (String)(revert ? GlobalSettings.getSitePrefix() : this.destination.getPath()));
        if (fullPath.getAbsolutePath().startsWith(destinationFolder + File.separatorChar)) {
            return fullPath.getAbsolutePath().substring(destinationFolder.length() + 1).replace(File.separatorChar, '/');
        }
        try {
            return Files.path((File)new File(destinationFolder), (File)fullPath);
        }
        catch (Exception ex) {
            return fullPath.getAbsolutePath();
        }
    }

    private boolean updateURIObject(Database db, URI uri, Member member, String scheme, String host, Integer port, String path, boolean unarchive, boolean archive) {
        try {
            Group sourceGroup = URIRule.getDefaultGroupForURI((URI)uri);
            Host hostObj = DatabaseQuery.getHostByName((Database)db, (String)host);
            if (hostObj == null) {
                this.error("Invalid host " + host);
                return false;
            }
            String previousPath = uri.getPath();
            uri.setScheme(scheme);
            uri.setHost(hostObj);
            uri.setPort(port);
            uri.setPath(path);
            URIRule.updateGroupURIs((Database)db, (URI)uri);
            URIRule.addURIHistoryXLink((URI)uri, (Member)member, null, null, (String)"move", null, (String)previousPath, null, (Database)db);
            Group destinationGroup = URIRule.getDefaultGroupForURI((URI)uri);
            if (destinationGroup != null) {
                XLink xl;
                String[] stringArray;
                Collection editGroups = GroupRule.getEditGroups((Database)db, (Group)destinationGroup, (URI)uri);
                Group admin = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
                if (archive) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Workflow";
                    stringArray = stringArray2;
                    stringArray2[1] = "Documentation-Release";
                } else {
                    String[] stringArray3 = new String[5];
                    stringArray3[0] = "Workflow";
                    stringArray3[1] = "archive-Workflow";
                    stringArray3[2] = "archive-Documentation-Release";
                    stringArray3[3] = "Documentation%";
                    stringArray = stringArray3;
                    stringArray3[4] = "XRef%";
                }
                Predicate pred = Predicates.predicateXLinkForLocatorContentRoleLike((Database)db, (String[])stringArray);
                for (Locator loc : uri.getLocatorsCol()) {
                    Collection lfxs;
                    if (archive && !"default".equals(loc.getFragment()) || (lfxs = loc.getXLinksForLocatorCol((Object)pred)) == null) continue;
                    for (LocatorForXLink lfx : lfxs) {
                        Collection newGroups;
                        XLink xl2 = lfx.getXLink();
                        if (!XLinkRule.belongsToGroup((XLink)xl2, (Group)sourceGroup)) continue;
                        if (xl2.getStatus() != null && ("Workflow".equals(xl2.getContentRole()) || "archive-Workflow".equals(xl2.getContentRole()) || "Documentation-Release".equals(xl2.getContentRole()) || "archive-Documentation-Release".equals(xl2.getContentRole()))) {
                            newGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
                            newGroups = GroupRule.removePublicGroup((Collection)newGroups);
                            if (archive) {
                                XLinkRule.archiveXLink((XLink)xl2);
                                for (XLink reply : xl2.getRepliesCol()) {
                                    XLinkRule.archiveXLink((XLink)reply);
                                }
                            } else if (!(!unarchive || XLinks.isDraft((XLink)xl2) && "archive-Workflow".equals(xl2.getContentRole()))) {
                                XLinkRule.unarchiveXLink((XLink)xl2);
                                for (XLink reply : xl2.getRepliesCol()) {
                                    if (XLinks.isDraft((XLink)reply) && "archive-Workflow".equals(reply.getContentRole())) continue;
                                    XLinkRule.unarchiveXLink((XLink)reply);
                                }
                            }
                        } else {
                            newGroups = xl2.getContentRole() != null && xl2.getContentRole().startsWith("Documentation") ? editGroups : XLinkRule.getXRefGroups((XLink)xl2, (Group)destinationGroup, (Database)db);
                        }
                        if (!newGroups.contains(admin)) {
                            newGroups.add(admin);
                        }
                        if (newGroups == null || !GroupRule.areGroupsDifferent((Collection)newGroups, (Collection)XLinkRule.getGroups((XLink)xl2))) continue;
                        XLinkRule.modifyGroups((Database)db, (XLink)xl2, (Collection)newGroups);
                        for (XLink reply : xl2.getRepliesCol()) {
                            XLinkRule.modifyGroups((Database)db, (XLink)reply, (Collection)newGroups);
                        }
                    }
                }
                if (!archive && (xl = uri.getXLink()) != null) {
                    XLinkRule.modifyGroups((Database)db, (XLink)xl, (Collection)editGroups);
                    Collection replies = xl.getRepliesCol();
                    for (XLink reply : replies) {
                        if ("uri-properties".equals(reply.getContentRole())) {
                            XLinkRule.modifyGroups((Database)db, (XLink)reply, (Collection)editGroups);
                            continue;
                        }
                        if (!"publication".equals(reply.getContentRole()) || !XLinkRule.belongsToGroup((XLink)reply, (Group)sourceGroup)) continue;
                        XLinkRule.modifyGroups((Database)db, (XLink)reply, (Collection)editGroups);
                    }
                }
                if (!this.commentGroups.isEmpty()) {
                    Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
                    this.commentsToIndex.addAll(XLinkRule.modifyGroupsByURI((Database)db, (URI)uri, (Group)group, (String[])this.commentGroups.toArray(new String[0]), (Object)Predicates.predicateXLinkForLocatorContentRoleLike((Database)db, (String[])new String[]{"Comment", "File Attachment", "archive-Comment", "archive-File Attachment"})));
                }
            }
            return true;
        }
        catch (DatabaseException ex) {
            this.error("Failed to " + (archive ? "archive " : "move ") + " URI " + uri.getId() + ": " + ex.getMessage());
            return false;
        }
    }

    public static MoveURIThread newInstance(boolean archive, String username, Group group) {
        return new MoveURIThread(archive, username, group);
    }

    protected static final class Destination {
        private final URI uri;
        private final GroupURI guri;

        public Destination(URI u) {
            this.uri = u;
            this.guri = null;
        }

        public Destination(GroupURI gu) {
            this.uri = null;
            this.guri = gu;
        }

        public String getScheme() {
            return this.uri == null ? this.guri.getScheme() : this.uri.getScheme();
        }

        public Host getHost() {
            return this.uri == null ? this.guri.getHost() : this.uri.getHost();
        }

        public Integer getPort() {
            return this.uri == null ? this.guri.getPort() : this.uri.getPort();
        }

        public String getDecodedPath() {
            return this.uri == null ? GroupURIs.truncatePath((String)URLCoder.decode((String)this.guri.getPath())) : this.uri.getDecodedPath();
        }

        public String getPath() {
            return this.uri == null ? GroupURIs.truncatePath((String)this.guri.getPath()) : this.uri.getPath();
        }
    }

    protected static final class URIToIndex {
        private final Long uriid;
        private final GroupURI guri;
        private final List<Group> removedGroups = new ArrayList<Group>();
        private final List<Group> addedGroups = new ArrayList<Group>();
        private final List<Group> modifiedGroups = new ArrayList<Group>();
        private final boolean unarchived;
        private String sourceFolder;

        URIToIndex(Long uid, GroupURI gu, boolean unarchive, String source) {
            this.uriid = uid;
            this.guri = gu;
            this.unarchived = unarchive;
            this.sourceFolder = source;
        }

        List<Group> addedGroups() {
            return this.addedGroups;
        }

        List<Group> removedGroups() {
            return this.removedGroups;
        }

        List<Group> modifiedGroups() {
            return this.modifiedGroups;
        }
    }

    protected static final class URIToMove {
        private final Long uriid;
        private File sourceFile;
        private URI uri = null;
        private final String newName;

        URIToMove(Long u, String n) {
            this.uriid = u;
            this.newName = n == null || n.isEmpty() ? null : n;
        }

        void computeURI(Database db) throws QueryFailedException {
            this.uri = DatabaseQuery.getURIById((Database)db, (Long)this.uriid);
            this.sourceFile = new File(URIRule.getRealPath((String)Settings.getContextPath(), (String)this.uri.getPath()));
        }

        public URI getURI() {
            return this.uri;
        }

        File getSourceFile() {
            return this.sourceFile;
        }

        public Long uriid() {
            return this.uriid;
        }

        String newName() {
            return this.newName;
        }
    }
}

