/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(member=true, uri=true, parameters={"url"})
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class MergeExternalURI
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeExternalURI.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditAllURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URL url;
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Member member = req.getMember();
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        try {
            url = RuleUtils.urlEncodeNormalize((String)urlString);
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "Invalid URL " + urlString + ": " + ex.getMessage());
            return;
        }
        URI muri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)url);
        if (muri == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URL not found");
            return;
        }
        if (!muri.getExternal().booleanValue()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URL is not external");
            return;
        }
        if (muri.equals((Object)uri)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URL can not be merged with itself");
            return;
        }
        HashSet<URI> xref_uris = new HashSet<URI>();
        ArrayList<CallSite> source_fragments = new ArrayList<CallSite>();
        List xrefs = DatabaseQuery.getLocatorForXLinksByURIReverseXRef((Database)db, (URI)muri);
        for (Object lfx : xrefs) {
            if (!MergeExternalURI.checkLocatorForXLink(res, muri, (LocatorForXLink)lfx)) {
                return;
            }
            URI suri = null;
            String fragment = null;
            for (LocatorForXLink lfx2 : lfx.getXLink().getLocatorsForXLinkCol()) {
                if (lfx2 == lfx) continue;
                Locator loc2 = lfx2.getLocator();
                suri = loc2.getURI();
                fragment = loc2.getFragment();
                break;
            }
            if (suri == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Reversexref ID " + lfx.getXLink().getId() + " does not have a source URI.");
                return;
            }
            String key = suri.getId() + "-" + fragment;
            if (source_fragments.contains(key)) continue;
            source_fragments.add((CallSite)((Object)key));
            if (!this.updateFragment(res, db, member, uri, muri, suri, fragment)) {
                return;
            }
            xref_uris.add(suri);
        }
        List discussions = DatabaseQuery.getLocatorForXLinksByURIDiscussion((Database)db, (URI)muri);
        for (LocatorForXLink lfx : discussions) {
            if (!MergeExternalURI.checkLocatorForXLink(res, muri, lfx)) {
                return;
            }
            Locator new_loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)lfx.getLocator().getFragment());
            lfx.setLocator(new_loc);
        }
        Date date = new Date();
        uri.setLastModified(date);
        muri.setArchived(Boolean.TRUE);
        muri.setDateArchived(date);
        muri.setLastModified(date);
        URIRule.addURIHistoryXLink((URI)muri, (Member)member, (Database)db);
        req.getTransaction().commitAndStart();
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch("Merging URL " + muri.getId() + " into URL " + uri.getId());
        changes.startBatch(db, batch);
        changes.modifyURI(db, batch, uri, Collections.emptyList());
        changes.archiveURI(db, batch, muri, Collections.emptyList());
        for (URI uri2 : xref_uris) {
            if (uri2.getExternal().booleanValue()) {
                changes.modifyURI(db, batch, uri2, Collections.emptyList());
                continue;
            }
            changes.modifyURI(db, batch, uri2, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri2.getId()));
        }
        for (LocatorForXLink lfx : discussions) {
            XLink xl = lfx.getXLink();
            Collection grps = XLinkRule.getGroups((XLink)xl);
            changes.modifyComment(db, xl, grps);
            if (lfx.getRole() != null) continue;
            for (XLink reply : xl.getRepliesCol()) {
                changes.modifyComment(db, reply, grps);
            }
        }
        changes.completeBatch(db, batch);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("uri-merge");
        out.field("links", (long)xrefs.size());
        out.field("discussions", (long)discussions.size());
        out.writeExternalURI(uri);
        out.endObject();
        out.flush();
    }

    private boolean updateFragment(GeneratorResponse res, Database db, Member author, URI uri, URI muri, URI suri, String fragment) throws IOException, DatabaseException {
        Group editGroup = GroupRule.getEditGroup((Database)db, null, (URI)suri);
        DocumentContentResolver resolver = new DocumentContentResolver(suri.getId(), editGroup.getName());
        resolver.setPSMLFormat(true);
        resolver.setFragment(fragment);
        StringWriter newcontent = new StringWriter();
        UpdateTargetURI replacer = new UpdateTargetURI(newcontent, muri.getId(), uri.getId());
        try {
            InputStream in = resolver.getContent(db);
            if (in.available() == 0) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Reversexref frag " + fragment + " doesn't exist in URIID " + suri.getId());
                return false;
            }
            XMLHelpers.parse((InputStream)in, (ContentHandler)replacer);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse document content: " + ex.getMessage());
            return false;
        }
        String content = newcontent.toString();
        LOGGER.debug("URIID {} fragment {} new content {}", new Object[]{suri.getId(), fragment, content});
        FragmentEditor editor = new FragmentEditor(suri, fragment, author, editGroup);
        editor.edit(db, content, "application/vnd.pageseeder.psml+xml", null, null, !"default".equalsIgnoreCase(fragment));
        if (editor.getStatus() != FragmentEditor.Status.OK) {
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String messages = msg.length() > 0 ? msg.substring(1) : "";
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to edit " + fragment + " on URIID " + suri.getId() + ": " + messages);
            return false;
        }
        suri.setLastModified(new Date());
        return true;
    }

    private static boolean checkLocatorForXLink(GeneratorResponse res, URI muri, LocatorForXLink lfx) {
        Locator loc = lfx.getLocator();
        if (!muri.equals((Object)loc.getURI())) {
            res.setError(GeneratorStatus.SERVER_ERROR, "LocatorForXLinkID " + lfx.getId() + " is not attached to URIID " + muri.getId());
            return false;
        }
        return true;
    }

    private final class UpdateTargetURI
    extends DefaultHandler {
        private XMLWriter xml = null;
        private final String oldURIID;
        private final String newURIID;

        UpdateTargetURI(Writer output, Long old_uriid, Long new_uriid) {
            this.xml = new XMLWriterNSImpl(output);
            this.oldURIID = old_uriid.toString();
            this.newURIID = new_uriid.toString();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.xml.setPrefixMapping(uri, prefix);
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            try {
                this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, lName, true);
                String uriid = null;
                if (("link".equals(lName) || "xref".equals(lName) || "blockxref".equals(lName)) && this.oldURIID.equals(atts.getValue("uriid"))) {
                    uriid = this.newURIID;
                }
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    if (uriid != null) {
                        if ("uriid".equals(name)) {
                            value = uriid;
                        } else if ("href".equals(name) || "docid".equals(name)) {
                            value = "";
                        }
                    }
                    this.xml.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), name, value);
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
        }

        @Override
        public void endElement(String uri, String lName, String qName) throws SAXException {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + lName, ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.xml.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
        }
    }
}

