/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.utils.SearchUtils;
import com.pageseeder.thread.PSMLContentMatchThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.slf4j.LoggerFactory;

@Requires(group=true, member=true, uri=true, parameters={"term"})
@PublicAPI
public final class MatchPSMLContentFolder
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        Group group = req.getGroup();
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        checks.add((PermissionCheck)new EditURICheck(group, req.getURI()));
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member member = req.getMember();
        URI folder = req.getURI();
        if (folder == null || !"folder".equals(folder.getType())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NOT_A_FOLDER);
            return;
        }
        Group group = req.getGroup();
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        String term = req.getParameter((Parameter)StandardParameters.term);
        boolean caseSensitive = req.getParameter("case-sensitive", true);
        boolean isRegex = req.getParameter("regex", false);
        boolean isWord = req.getParameter("word", false);
        PSMLContentMatchThread thread = PSMLContentMatchThread.newInstance(member.getUsername(), group, term);
        thread.setCaseSensitive(caseSensitive);
        thread.setWord(isWord);
        thread.setLiteral(!isRegex);
        thread.setResultAttribute("folder", folder.getPath());
        thread.setResultAttribute("folderuri", folder.getId().toString());
        Object path = folder.getPath();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            List<Long> documents = this.canUseIndex(isWord, term) ? this.listMatchingDescendants(req.getDatabase(), group, folder, term) : this.listDescendants(req.getDatabase(), folder);
            boolean foundOne = false;
            for (Long doc : documents) {
                thread.addURI(doc);
                foundOne = true;
            }
            if (!foundOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_URIS_TO_PROCESS, "No documents to search!");
                return;
            }
        }
        catch (QueryFailedException | ParseException | IndexException ex) {
            LoggerFactory.getLogger(MatchPSMLContentFolder.class).error("Failed to load documents", ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load documents in folder: " + ex.getMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("folder-scan");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private List<Long> listMatchingDescendants(Database db, Group group, URI folder, String searchString) throws ParseException, IndexException {
        Catalog catalog = SearchUtils.getGlobalCatalog();
        GroupIndex index = IndexMaster.getInstance().getIndex(db, group);
        Analyzer analyser = SearchUtils.loadAnalyzer(Collections.singletonList(index), (Group)group);
        PageSeederQuery query = new PageSeederQuery.Builder().catalog(catalog).analyser(analyser).question("\"" + searchString + "\"").defaultField("pscontent").addStringFilter("pstype", "document", BooleanClause.Occur.MUST).addStringFilter("psmediatype", "application/vnd.pageseeder.psml+xml", BooleanClause.Occur.MUST).addStringFilter("psancestor", folder.getPath(), BooleanClause.Occur.MUST).build();
        SearchResults results = IndexMaster.getInstance().search(db, group, (SearchQuery)query, 10000, 1);
        ArrayList<Long> ids = new ArrayList<Long>(results.getLastHit());
        for (Document r : results.documents()) {
            ids.add(Long.parseLong(r.getField("psid").stringValue()));
        }
        return ids;
    }

    private List<Long> listDescendants(Database db, URI folder) throws QueryFailedException {
        String mediatype = "application/vnd.pageseeder.psml+xml";
        Object path = folder.getPath();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return DatabaseQuery.getURIsBySchemeHostPortSubpathMediaDocumentType((Database)db, (String)folder.getScheme(), (String)folder.getHost().getName(), (Integer)folder.getPort(), (String)path, (String)mediatype, null).stream().filter(f -> !"folder".equals(f.getType())).map(URI::getId).collect(Collectors.toList());
    }

    boolean canUseIndex(boolean isWord, String searchString) {
        String[] terms;
        if (!isWord || searchString.matches("[^a-z\\s]")) {
            return false;
        }
        for (String term : terms = searchString.split("\\s+")) {
            if (!EnglishAnalyzer.ENGLISH_STOP_WORDS_SET.contains((CharSequence)term)) continue;
            return false;
        }
        return true;
    }
}

