/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.inspect.FileInspection;
import com.pageseeder.base.inspect.PSMLFileInspector;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.member.MemberErrorID;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.xml.sax.ContentHandler;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class InspectURI
implements Generator,
SingleCheck,
Cacheable {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String path = req.getParameter((Parameter)StandardParameters.path);
        if (path == null) {
            if (req.getURI() == null) {
                return new NoCheck();
            }
            return new ViewURICheck(req.getGroup(), req.getURI());
        }
        return new EditURICheck(req.getGroup());
    }

    public String getETag(GeneratorRequest req) {
        File f = this.findFile(req, null);
        if (f == null) {
            return null;
        }
        return String.valueOf(f.lastModified());
    }

    /*
     * Unable to fully structure code
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        f = this.findFile(req, res);
        if (f == null) {
            return;
        }
        out = res.getUniversalWriter();
        out.startObject("file");
        out.field("name", f.getName());
        attributes = null;
        if (f.getName().toLowerCase().endsWith(".psml")) {
            inspector = new PSMLFileInspector();
            try {
                in = FileUtils.openInputStream((File)f);
                try {
                    XMLHelpers.parse((InputStream)in, (ContentHandler)inspector);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                inspected = inspector.inspect(f);
                if (inspected != null) {
                    attributes = inspected;
                }
                if ((properties = inspector.getMetadataProperties()).isEmpty()) ** GOTO lbl34
                out.startCollection("metadata");
                for (PSMLFileInspector.PSMLProperty prop : properties) {
                    prop.print((OutputPrinter)out);
                }
                out.endCollection();
            }
            catch (FoundationException | IOException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Failed to inspect URL " + f.getName() + ": " + ex.getMessage());
                return;
            }
        } else {
            attributes = FileInspection.inspect((File)f);
        }
lbl34:
        // 3 sources

        if (attributes != null) {
            for (String att : attributes.keySet()) {
                out.startObject("field");
                out.field("name", att);
                out.field("value", (String)attributes.get(att));
                out.endObject();
            }
        }
        out.endObject();
    }

    private File findFile(GeneratorRequest req, GeneratorResponse res) {
        File f;
        String path = req.getParameter((Parameter)StandardParameters.path);
        if (path == null) {
            URI uri = req.getURI();
            if (uri == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "No file to inspect!");
                }
                return null;
            }
            f = new File(URIRule.getRealPath((String)uri.getPath()));
        } else {
            Member member = req.getMember();
            if (member == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_REQUIRED);
                }
                return null;
            }
            Group group = req.getGroup();
            String uploadid = req.getParameter((Parameter)StandardParameters.uploadid);
            if (uploadid != null && !LoadingZone.isValidUploadID(uploadid)) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Invalid uploadid");
                }
                return null;
            }
            LoadingZone zone = new LoadingZone(group.getName(), req.getGroup().getOwnerDirectory(), member.getId(), uploadid);
            f = new File(zone.baseDirectory(), path);
        }
        if (URIRule.isPSML((File)f) && (path == null || !path.startsWith("META-INF/_urls/"))) {
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "PSML files cannot be inspected.");
            }
            return null;
        }
        return f;
    }
}

