/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.XLink;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.uri.History;
import com.pageseeder.uri.HistoryEvent;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@Requires(database=true, group=true, parameters={"events"})
@Output(types={OutputType.XML, OutputType.JSON, OutputType.CSV})
public final class GetURIsHistory
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 100L;
    private static final Map<String, String> CSV_COLUMNS = new LinkedHashMap<String, String>();

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws GetCollectionException {
        String folder = req.getParameter((Parameter)StandardParameters.folder, "");
        Group group = req.getGroup();
        if (!folder.isEmpty()) {
            GroupURI guri = GroupURIRule.getDefaultGroupURI((Group)req.getGroup());
            if (guri == null) {
                return new ForbiddenCheck();
            }
            String uriString = guri.getScheme() + "://" + guri.getHost().getName() + ":" + guri.getPort() + folder;
            return new ViewURICheck(group, uriString);
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Publication pub;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 100L);
        String types = req.getParameter((Parameter)StandardParameters.events, "");
        String from = req.getParameter((Parameter)StandardParameters.from, "");
        String to = req.getParameter((Parameter)StandardParameters.to, "");
        String author = req.getParameter((Parameter)StandardParameters.author, "");
        String folder = req.getParameter((Parameter)StandardParameters.folder, "");
        String documenttype = req.getParameter((Parameter)StandardParameters.documenttype, "");
        String label = req.getParameter((Parameter)StandardParameters.label, "");
        String pubid = req.getParameter((Parameter)StandardParameters.publicationid, "");
        ArrayList<HistoryEvent.EventType> eventTypes = new ArrayList<HistoryEvent.EventType>();
        for (String type : types.split(",")) {
            HistoryEvent.EventType et = HistoryEvent.EventType.fromString(type);
            if (et == null) continue;
            eventTypes.add(et);
        }
        if (eventTypes.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid parameter 'events'");
            return;
        }
        Member theauthor = null;
        if (!author.isEmpty() && (theauthor = MemberRule.getMember((Database)req.getDatabase(), (String)author)) == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MATCHING_MEMBER);
            return;
        }
        Date fromDate = null;
        if (!from.isEmpty()) {
            try {
                fromDate = ISO8601.parseAuto((String)from);
            }
            catch (ParseException ex) {
                fromDate = null;
            }
        }
        if (fromDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            fromDate = cal.getTime();
        }
        Date toDate = null;
        if (!to.isEmpty()) {
            try {
                toDate = ISO8601.parseAuto((String)to);
            }
            catch (ParseException ex) {
                toDate = null;
            }
        }
        XLink pub_xlink = null;
        if (!pubid.isEmpty() && (pub = Publications.getPublicationByPublicationIDGroup((Database)db, (String)pubid, (Group)group)) != null) {
            pub_xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        }
        History history = new History(theauthor, fromDate, toDate, label.isEmpty() ? null : label, folder.isEmpty() ? null : folder, documenttype.isEmpty() ? null : documenttype, group, pub_xlink, db);
        for (HistoryEvent.EventType type : eventTypes) {
            history.addEventType(type);
        }
        history.computeEvents(page, pagesize);
        UniversalPrinter out = res.getUniversalWriter();
        if (out.getType() == OutputType.CSV) {
            out.setCSVOutput("event", CSV_COLUMNS);
            out.setCSVDateTimeFields(Collections.singletonList("datetime"));
        }
        history.print((OutputPrinter)out);
        out.flush();
    }

    static {
        CSV_COLUMNS.put("id", "ID");
        CSV_COLUMNS.put("type", "Type");
        CSV_COLUMNS.put("datetime", "Datetime");
        CSV_COLUMNS.put("author.fullname", "Author (Full name)");
        CSV_COLUMNS.put("uri.id", "URI ID");
        CSV_COLUMNS.put("uri.title", "URI Title");
        CSV_COLUMNS.put("uri.path", "Path");
        CSV_COLUMNS.put("uri.docid", "Doc ID");
        CSV_COLUMNS.put("uri.documenttype", "Document type");
        CSV_COLUMNS.put("title", "Title");
        CSV_COLUMNS.put("fragment", "Fragment");
        CSV_COLUMNS.put("labels", "Labels");
    }
}

