/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.History;
import com.pageseeder.uri.HistoryEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Requires(database=true, uri=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON, OutputType.CSV})
public final class GetURIHistory
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 100L;
    private static final Map<String, String> CSV_COLUMNS = new LinkedHashMap<String, String>();

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 100L);
        String types = req.getParameter((Parameter)StandardParameters.events, "");
        History history = new History(req.getURI(), req.getGroup(), req.getDatabase());
        for (String type : types.split(",")) {
            history.addEventType(HistoryEvent.EventType.fromString(type));
        }
        history.computeEvents(page, pagesize);
        UniversalPrinter out = res.getUniversalWriter();
        if (out.getType() == OutputType.CSV) {
            out.setCSVOutput("event", CSV_COLUMNS);
            out.setCSVDateTimeFields(Collections.singletonList("datetime"));
        }
        history.print((OutputPrinter)out);
        out.flush();
    }

    static {
        CSV_COLUMNS.put("id", "ID");
        CSV_COLUMNS.put("type", "Type");
        CSV_COLUMNS.put("datetime", "Datetime");
        CSV_COLUMNS.put("author.fullname", "Author (Full name)");
        CSV_COLUMNS.put("title", "Title");
        CSV_COLUMNS.put("fragment", "Fragment");
        CSV_COLUMNS.put("labels", "Labels");
    }
}

