/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.IOException;

@Requires(uri=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class GetExternalURI
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMemberCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("all".equals(req.getParameter((Parameter)StandardParameters.returngroups))) {
            return new CreateProjectCheck();
        }
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URI uri = req.getURI();
        Long memberid = req.getMember().getId();
        Database db = req.getDatabase();
        String allgroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        UniversalPrinter out = res.getUniversalWriter();
        out.writeExternalURI(uri, false, null);
        if (!"none".equals(allgroups)) {
            out.writeURLUsage(uri, memberid, "all".equals(allgroups), db);
        }
        out.endObject();
        out.flush();
    }
}

