/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.url.URLUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class EditExternalURI
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditExternalURI.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        String url = req.getParameter((Parameter)StandardParameters.url);
        try {
            if (url != null && !URIRule.isExternal((URL)RuleUtils.urlEncodeNormalize((String)url), (Database)req.getDatabase())) {
                return new ForbiddenCheck();
            }
        }
        catch (MalformedURLException e) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditAllURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String urlString = req.getParameter((Parameter)StandardParameters.url, null);
        String title = req.getParameter((Parameter)StandardParameters.title);
        String type = req.getParameter((Parameter)StandardParameters.type, null);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String sizeString = req.getParameter((Parameter)StandardParameters.size);
        String mediatype = req.getParameter((Parameter)StandardParameters.mediatype);
        String folder = req.getParameter((Parameter)StandardParameters.folder);
        String labelsString = req.getParameter((Parameter)StandardParameters.labels);
        if (!URIUtils.checkLabels(res, labelsString)) {
            return;
        }
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Member author = req.getMember();
        if (type != null && !URIRule.isValidDocumentType((String)type)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The URL type is not valid");
            return;
        }
        String originalPath = null;
        boolean somethingChanged = false;
        String previousPath = null;
        URLConfig config = null;
        if (urlString != null) {
            URL url;
            while (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            try {
                url = RuleUtils.urlEncodeNormalize((String)urlString);
                originalPath = RuleUtils.urlEncodeNormalize((String)urlString, (boolean)false).getFile();
                if (originalPath.equals(url.getFile())) {
                    originalPath = null;
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.error("Invalid url parameter {}", (Object)urlString);
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL);
                return;
            }
            URI otheruri = URIRule.getURIByURL((Database)db, (URL)url);
            if (otheruri != null && !otheruri.getId().equals(uri.getId())) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EXISTING_URL, "There is already a URI with the URL " + urlString);
                return;
            }
            try {
                config = URLUtils.findURLConfig(url, type, mediatype);
            }
            catch (FoundationException e) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.INVALID_PSML_CONFIG_FILE, "Failed to load URL config file for type " + type);
                return;
            }
            if (config != null) {
                List domains = config.getDomains();
                if (!domains.isEmpty() && !domains.contains(url.getHost())) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL_DOMAIN);
                    return;
                }
                List mediatypes = config.getMediatypes();
                if (!mediatypes.isEmpty() && !mediatypes.contains(mediatype)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL_MEDIATYPE);
                    return;
                }
            }
            int oldPathLength = uri.getPath().length();
            String uriHost = url.getHost();
            Host host = DatabaseQuery.getHostByName((Database)db, (String)uriHost);
            if (host == null) {
                host = HostRule.createHost((Database)db, (String)uriHost, (boolean)true);
            }
            previousPath = uri.getPath();
            uri.setScheme(url.getProtocol());
            uri.setPort(Integer.valueOf(url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort()));
            uri.setPath(url.getFile() == null || url.getFile().isEmpty() ? "/" : url.getFile());
            uri.setHost(host);
            somethingChanged = true;
        }
        boolean uriMetadataChanged = originalPath != null || somethingChanged;
        long size = -1L;
        if (sizeString != null) {
            try {
                size = Long.valueOf(sizeString);
            }
            catch (NumberFormatException ex) {
                size = -1L;
            }
            if (size < 0L) {
                LOGGER.error("Invalid size for URL: {}", (Object)sizeString);
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_SIZE);
                return;
            }
        }
        if (type != null || (urlString != null || mediatype != null) && config != null) {
            String behavior;
            if (type == null) {
                type = config.getURLType();
            }
            String string = behavior = type.isEmpty() || "default".equals(type) ? null : "url-" + type + "-";
            if (this.areDifferent(behavior, uri.getBehavior())) {
                uri.setBehavior(behavior);
                somethingChanged = true;
            }
        }
        if (mediatype != null) {
            String string = mediatype = mediatype.isEmpty() ? null : mediatype;
            if (this.areDifferent(mediatype, uri.getType())) {
                uri.setType(mediatype);
                somethingChanged = true;
            }
        }
        if (size >= 0L && (uri.getSize() == null || size != uri.getSize())) {
            uri.setSize(Long.valueOf(size));
            somethingChanged = true;
        }
        boolean[] changed = this.setCommonFields(uri, db, author, title, description, labelsString, folder);
        boolean bl = somethingChanged = somethingChanged || changed[0];
        if (uriMetadataChanged || changed[1]) {
            URIRule.addURIHistoryXLink((URI)uri, (Member)author, null, (String)originalPath, null, null, previousPath, null, (Database)db);
        }
        if (somethingChanged) {
            Date now = new Date();
            uri.setLastModified(now);
        }
        boolean emailFailed = false;
        boolean emailDelayed = false;
        if (somethingChanged) {
            URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
            req.getTransaction().commitAndStart();
            ChangesManager manager = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch("Modifying properties of external URI " + uri.getId());
            manager.startBatch(db, batch);
            ChangesManager.getInstance().modifyURI(db, batch, uri, Collections.emptyList());
            if (changed[2]) {
                Comments.indexCommentsTasksWorkflows(db, uri, manager, batch);
            }
            PSML.indexXRefSourceTargetURIsWithBatch(db, uri, batch);
            manager.completeBatch(db, batch);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("uri-modification");
        if (emailFailed) {
            out.field("notification-email-failed", true);
        }
        if (emailDelayed) {
            out.field("notification-email-delayed", true);
        }
        out.writeExternalURI(uri);
        out.endObject();
        out.flush();
    }

    private boolean[] setCommonFields(URI uri, Database db, Member author, String title, String description, String labelsString, String folder) {
        String[] labels;
        boolean somethingChanged = false;
        boolean metadataChanged = false;
        boolean titleUpdated = false;
        if (title != null) {
            String thetitle;
            String string = thetitle = title.isEmpty() ? null : title;
            if (this.areDifferent(thetitle, uri.getUserTitle())) {
                uri.setUserTitle(thetitle);
                somethingChanged = true;
                metadataChanged = true;
                titleUpdated = true;
            }
        }
        if (description != null) {
            String thedescription;
            String string = thedescription = description.isEmpty() ? null : description;
            if (this.areDifferent(thedescription, uri.getDescription())) {
                uri.setDescription(thedescription);
                somethingChanged = true;
                metadataChanged = true;
            }
        }
        String[] stringArray = labels = labelsString == null || labelsString.isEmpty() ? null : labelsString.split(",");
        if (labelsString != null && Labels.labelsAreDifferent((String[])labels, (String[])Labels.getLabels((URI)uri))) {
            Labels.setLabels((URI)uri, (String[])labels);
            somethingChanged = true;
            metadataChanged = true;
        }
        if (uri.isFolder()) {
            uri.setFolder(null);
            somethingChanged = true;
        }
        return new boolean[]{somethingChanged, metadataChanged, titleUpdated};
    }

    private boolean areDifferent(String first, String second) {
        return first == null && second != null || first != null && !first.equals(second);
    }
}

