/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DeleteURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true)
@PublicAPI
public final class DeleteExternalURI
implements Generator,
SingleCheck {
    @ContentPermission(value=DeleteURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new DeleteURICheck(req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        Long id = uri.getId();
        String docid = uri.getDocID();
        String path = uri.getPath();
        URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
        URIRule.deleteURI((Database)db, (URI)uri);
        ChangesManager.getInstance().deleteURL(db, id, docid, path, Collections.emptyList());
        XMLWriter xml = res.getXMLWriter();
        xml.emptyElement("uri-delete");
    }
}

