/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.MoveURIThread;
import com.pageseeder.uri.URIErrorID;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ArchiveURI
implements Generator,
SingleCheck {
    private static final int MAX_COUNTER = 1000000000;

    @ContentPermission(value=ArchiveURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        if (URIs.isExternal((URI)uri)) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ArchiveURICheck(uri, req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        String name;
        GroupURI guri;
        URI uri = req.getURI();
        Group grp = req.getGroup();
        Database db = req.getDatabase();
        boolean removexrefs = req.getParameter((Parameter)StandardParameters.removexrefs, false);
        String archivePath = GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', '/') + "/archive";
        if (archivePath.equalsIgnoreCase(uri.getPath())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ILLEGAL_ARCHIVE);
            return;
        }
        if (uri.getPath().startsWith(archivePath + "/")) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ALREADY_ARCHIVED);
            return;
        }
        try {
            guri = GroupURIRule.getDefaultGroupURI((Group)grp);
            if (guri == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_DEFAULT_GROUPURI);
                return;
            }
        }
        catch (GetCollectionException e) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to compute default Group URI.");
            return;
        }
        this.getFolderForSchemeHostPortPath(db, req.getTransaction(), guri.getScheme(), guri.getHost().getName(), guri.getPort(), archivePath);
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        int month = now.get(2) + 1;
        archivePath = archivePath + "/" + now.get(1);
        this.getFolderForSchemeHostPortPath(db, req.getTransaction(), guri.getScheme(), guri.getHost().getName(), guri.getPort(), archivePath);
        archivePath = archivePath + "/" + (month < 10 ? "0" : "") + month;
        this.getFolderForSchemeHostPortPath(db, req.getTransaction(), guri.getScheme(), guri.getHost().getName(), guri.getPort(), archivePath);
        try {
            name = this.findArchiveName(db, uri, archivePath);
        }
        catch (QueryFailedException e) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to compute archive name.");
            return;
        }
        Long uriid = uri.getId();
        MoveURIThread thread = MoveURIThread.newInstance(true, req.getMember().getUsername(), grp);
        thread.addURIToMove(uriid, name);
        thread.setCommentGroups(Collections.singletonList(grp.getName()));
        thread.setDestinationDetails(guri.getScheme(), guri.getHost().getName(), guri.getPort(), archivePath);
        thread.setRemoveXRefs(removexrefs);
        if ("folder".equals(uri.getType())) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("uri-archive");
            thread.print((OutputPrinter)out);
            out.endObject();
            out.flush();
        } else {
            ProcessManager manager = ProcessManager.getInstance();
            manager.prepareForStart((ProcessThread)thread, true);
            if (!thread.run(db, req.getTransaction())) {
                req.getTransaction().abort();
                res.setError(GeneratorStatus.BAD_REQUEST, thread.getCurrentStatus().getMessage());
            } else {
                UniversalPrinter out = res.getUniversalWriter();
                out.startObject("uri-archive");
                out.field("threadid", thread.getThreadID());
                if (thread.hasWarning()) {
                    out.field("warning", true);
                }
                out.writeURI(DatabaseQuery.getURIById((Database)db, (Long)uriid));
                out.endObject();
                out.flush();
            }
            manager.clearIfFinished(thread.getThreadID());
        }
    }

    private String findArchiveName(Database db, URI uri, String archiveRoot) throws QueryFailedException {
        String[] oldFilename = URIRule.getFilename((URI)uri);
        oldFilename[0] = RuleUtils.replaceNonFilenameChars((String)oldFilename[0]);
        boolean folder = URIRule.isFolder((URI)uri);
        boolean filter = URIs.isExternal((URI)uri);
        String archiveFilename = oldFilename[0] + oldFilename[1];
        for (int i = 1; i < 1000000000; ++i) {
            URI turi;
            String real_path;
            boolean exists = false;
            if (!filter && new File(real_path = URIRule.getRealPath((String)Settings.getContextPath(), (String)(archiveRoot + "/" + archiveFilename))).exists()) {
                exists = true;
            }
            if (!exists && (turi = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)RuleUtils.urlEncodeFilepath((String)(archiveRoot + "/" + archiveFilename)))) != null) {
                exists = true;
            }
            if (!exists) break;
            archiveFilename = folder ? oldFilename[0] + oldFilename[1] + "-" + i : oldFilename[0] + "-" + i + oldFilename[1];
        }
        return folder ? archiveFilename : archiveFilename.replaceAll("\\.[^\\.]*?$", "");
    }

    private URI getFolderForSchemeHostPortPath(Database db, Transaction tr, String scheme, String host, Integer port, String path) throws DatabaseException {
        URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)path);
        if (uri == null) {
            uri = URIRule.createURIForSchemeHostPortPathType((Database)db, (Transaction)tr, (String)scheme, (String)host, (Integer)port, (String)path, (String)"folder");
            if (uri == null) {
                throw new DatabaseException("No group URI for: " + scheme + "://" + host + ":" + port + path);
            }
            String real_path = URIRule.getRealPath((String)Settings.getContextPath(), (String)path);
            if (!new File(real_path).mkdirs()) {
                throw new DatabaseException("Unable to create directory for: " + scheme + "://" + host + ":" + port + path);
            }
        }
        return uri;
    }
}

